package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFeatureConsistencyCheckJobConfig invokes the pairecservice.GetFeatureConsistencyCheckJobConfig API synchronously
func (client *Client) GetFeatureConsistencyCheckJobConfig(request *GetFeatureConsistencyCheckJobConfigRequest) (response *GetFeatureConsistencyCheckJobConfigResponse, err error) {
	response = CreateGetFeatureConsistencyCheckJobConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetFeatureConsistencyCheckJobConfigWithChan invokes the pairecservice.GetFeatureConsistencyCheckJobConfig API asynchronously
func (client *Client) GetFeatureConsistencyCheckJobConfigWithChan(request *GetFeatureConsistencyCheckJobConfigRequest) (<-chan *GetFeatureConsistencyCheckJobConfigResponse, <-chan error) {
	responseChan := make(chan *GetFeatureConsistencyCheckJobConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFeatureConsistencyCheckJobConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFeatureConsistencyCheckJobConfigWithCallback invokes the pairecservice.GetFeatureConsistencyCheckJobConfig API asynchronously
func (client *Client) GetFeatureConsistencyCheckJobConfigWithCallback(request *GetFeatureConsistencyCheckJobConfigRequest, callback func(response *GetFeatureConsistencyCheckJobConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFeatureConsistencyCheckJobConfigResponse
		var err error
		defer close(result)
		response, err = client.GetFeatureConsistencyCheckJobConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFeatureConsistencyCheckJobConfigRequest is the request struct for api GetFeatureConsistencyCheckJobConfig
type GetFeatureConsistencyCheckJobConfigRequest struct {
	*requests.RoaRequest
	FeatureConsistencyCheckJobConfigId string `position:"Path" name:"FeatureConsistencyCheckJobConfigId"`
	InstanceId                         string `position:"Query" name:"InstanceId"`
}

// GetFeatureConsistencyCheckJobConfigResponse is the response struct for api GetFeatureConsistencyCheckJobConfig
type GetFeatureConsistencyCheckJobConfigResponse struct {
	*responses.BaseResponse
	RequestId                     string `json:"RequestId" xml:"RequestId"`
	Name                          string `json:"Name" xml:"Name"`
	SceneId                       string `json:"SceneId" xml:"SceneId"`
	SceneName                     string `json:"SceneName" xml:"SceneName"`
	Status                        string `json:"Status" xml:"Status"`
	CompareFeature                bool   `json:"CompareFeature" xml:"CompareFeature"`
	LatestJobId                   string `json:"LatestJobId" xml:"LatestJobId"`
	LatestJobGmtSamplingStartTime string `json:"LatestJobGmtSamplingStartTime" xml:"LatestJobGmtSamplingStartTime"`
	LatestJobGmtSamplingEndTime   string `json:"LatestJobGmtSamplingEndTime" xml:"LatestJobGmtSamplingEndTime"`
	SampleRate                    string `json:"SampleRate" xml:"SampleRate"`
	FeatureLandingResourceId      string `json:"FeatureLandingResourceId" xml:"FeatureLandingResourceId"`
	FeatureLandingResourceUri     string `json:"FeatureLandingResourceUri" xml:"FeatureLandingResourceUri"`
	EasServiceName                string `json:"EasServiceName" xml:"EasServiceName"`
	FgJsonFileName                string `json:"FgJsonFileName" xml:"FgJsonFileName"`
	UserTable                     string `json:"UserTable" xml:"UserTable"`
	UserIdField                   string `json:"UserIdField" xml:"UserIdField"`
	UserTablePartitionField       string `json:"UserTablePartitionField" xml:"UserTablePartitionField"`
	UserTablePartitionFieldFormat string `json:"UserTablePartitionFieldFormat" xml:"UserTablePartitionFieldFormat"`
	ItemTable                     string `json:"ItemTable" xml:"ItemTable"`
	ItemIdField                   string `json:"ItemIdField" xml:"ItemIdField"`
	ItemTablePartitionField       string `json:"ItemTablePartitionField" xml:"ItemTablePartitionField"`
	ItemTablePartitionFieldFormat string `json:"ItemTablePartitionFieldFormat" xml:"ItemTablePartitionFieldFormat"`
	GenerateZip                   bool   `json:"GenerateZip" xml:"GenerateZip"`
	ServiceId                     string `json:"ServiceId" xml:"ServiceId"`
	ServiceName                   string `json:"ServiceName" xml:"ServiceName"`
	WorkflowName                  string `json:"WorkflowName" xml:"WorkflowName"`
	OssResourceId                 string `json:"OssResourceId" xml:"OssResourceId"`
	OssBucket                     string `json:"OssBucket" xml:"OssBucket"`
	EasyRecVersion                string `json:"EasyRecVersion" xml:"EasyRecVersion"`
	EasyRecPackagePath            string `json:"EasyRecPackagePath" xml:"EasyRecPackagePath"`
	FgJarVersion                  string `json:"FgJarVersion" xml:"FgJarVersion"`
	FeaturePriority               string `json:"FeaturePriority" xml:"FeaturePriority"`
	FeatureDisplayExclude         string `json:"FeatureDisplayExclude" xml:"FeatureDisplayExclude"`
	GmtCreateTime                 string `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime               string `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	UseFeatureStore               bool   `json:"UseFeatureStore" xml:"UseFeatureStore"`
	FeatureStoreProjectName       string `json:"FeatureStoreProjectName" xml:"FeatureStoreProjectName"`
	FeatureStoreModelId           string `json:"FeatureStoreModelId" xml:"FeatureStoreModelId"`
	FeatureStoreUserId            string `json:"FeatureStoreUserId" xml:"FeatureStoreUserId"`
	FeatureStoreItemId            string `json:"FeatureStoreItemId" xml:"FeatureStoreItemId"`
	FeatureStoreSeqFeatureView    string `json:"FeatureStoreSeqFeatureView" xml:"FeatureStoreSeqFeatureView"`
	FeatureStoreProjectId         string `json:"FeatureStoreProjectId" xml:"FeatureStoreProjectId"`
	WorkspaceId                   string `json:"WorkspaceId" xml:"WorkspaceId"`
	VpcId                         string `json:"VpcId" xml:"VpcId"`
	SwitchId                      string `json:"SwitchId" xml:"SwitchId"`
	SecurityGroupId               string `json:"SecurityGroupId" xml:"SecurityGroupId"`
	DefaultRoute                  string `json:"DefaultRoute" xml:"DefaultRoute"`
	DatasetId                     string `json:"DatasetId" xml:"DatasetId"`
	DatasetType                   string `json:"DatasetType" xml:"DatasetType"`
	DatasetUri                    string `json:"DatasetUri" xml:"DatasetUri"`
	DatasetMountPath              string `json:"DatasetMountPath" xml:"DatasetMountPath"`
	DatasetName                   string `json:"DatasetName" xml:"DatasetName"`
	PredictWorkerCount            int    `json:"PredictWorkerCount" xml:"PredictWorkerCount"`
	PredictWorkerCpu              int    `json:"PredictWorkerCpu" xml:"PredictWorkerCpu"`
	PredictWorkerMemory           int    `json:"PredictWorkerMemory" xml:"PredictWorkerMemory"`
}

// CreateGetFeatureConsistencyCheckJobConfigRequest creates a request to invoke GetFeatureConsistencyCheckJobConfig API
func CreateGetFeatureConsistencyCheckJobConfigRequest() (request *GetFeatureConsistencyCheckJobConfigRequest) {
	request = &GetFeatureConsistencyCheckJobConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetFeatureConsistencyCheckJobConfig", "/api/v1/featureconsistencycheck/jobconfigs/[FeatureConsistencyCheckJobConfigId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFeatureConsistencyCheckJobConfigResponse creates a response to parse from GetFeatureConsistencyCheckJobConfig response
func CreateGetFeatureConsistencyCheckJobConfigResponse() (response *GetFeatureConsistencyCheckJobConfigResponse) {
	response = &GetFeatureConsistencyCheckJobConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
