package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExperimentGroup invokes the pairecservice.DeleteExperimentGroup API synchronously
func (client *Client) DeleteExperimentGroup(request *DeleteExperimentGroupRequest) (response *DeleteExperimentGroupResponse, err error) {
	response = CreateDeleteExperimentGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExperimentGroupWithChan invokes the pairecservice.DeleteExperimentGroup API asynchronously
func (client *Client) DeleteExperimentGroupWithChan(request *DeleteExperimentGroupRequest) (<-chan *DeleteExperimentGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteExperimentGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExperimentGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExperimentGroupWithCallback invokes the pairecservice.DeleteExperimentGroup API asynchronously
func (client *Client) DeleteExperimentGroupWithCallback(request *DeleteExperimentGroupRequest, callback func(response *DeleteExperimentGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExperimentGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteExperimentGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExperimentGroupRequest is the request struct for api DeleteExperimentGroup
type DeleteExperimentGroupRequest struct {
	*requests.RoaRequest
	InstanceId        string `position:"Query" name:"InstanceId"`
	ExperimentGroupId string `position:"Path" name:"ExperimentGroupId"`
}

// DeleteExperimentGroupResponse is the response struct for api DeleteExperimentGroup
type DeleteExperimentGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExperimentGroupRequest creates a request to invoke DeleteExperimentGroup API
func CreateDeleteExperimentGroupRequest() (request *DeleteExperimentGroupRequest) {
	request = &DeleteExperimentGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteExperimentGroup", "/api/v1/experimentgroups/[ExperimentGroupId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteExperimentGroupResponse creates a response to parse from DeleteExperimentGroup response
func CreateDeleteExperimentGroupResponse() (response *DeleteExperimentGroupResponse) {
	response = &DeleteExperimentGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
