package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEngineConfig invokes the pairecservice.DeleteEngineConfig API synchronously
func (client *Client) DeleteEngineConfig(request *DeleteEngineConfigRequest) (response *DeleteEngineConfigResponse, err error) {
	response = CreateDeleteEngineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEngineConfigWithChan invokes the pairecservice.DeleteEngineConfig API asynchronously
func (client *Client) DeleteEngineConfigWithChan(request *DeleteEngineConfigRequest) (<-chan *DeleteEngineConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteEngineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEngineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEngineConfigWithCallback invokes the pairecservice.DeleteEngineConfig API asynchronously
func (client *Client) DeleteEngineConfigWithCallback(request *DeleteEngineConfigRequest, callback func(response *DeleteEngineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEngineConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteEngineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEngineConfigRequest is the request struct for api DeleteEngineConfig
type DeleteEngineConfigRequest struct {
	*requests.RoaRequest
	EngineConfigId string `position:"Path" name:"EngineConfigId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// DeleteEngineConfigResponse is the response struct for api DeleteEngineConfig
type DeleteEngineConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEngineConfigRequest creates a request to invoke DeleteEngineConfig API
func CreateDeleteEngineConfigRequest() (request *DeleteEngineConfigRequest) {
	request = &DeleteEngineConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteEngineConfig", "/api/v1/engineconfigs/[EngineConfigId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteEngineConfigResponse creates a response to parse from DeleteEngineConfig response
func CreateDeleteEngineConfigResponse() (response *DeleteEngineConfigResponse) {
	response = &DeleteEngineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
