package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateABMetric invokes the pairecservice.CreateABMetric API synchronously
func (client *Client) CreateABMetric(request *CreateABMetricRequest) (response *CreateABMetricResponse, err error) {
	response = CreateCreateABMetricResponse()
	err = client.DoAction(request, response)
	return
}

// CreateABMetricWithChan invokes the pairecservice.CreateABMetric API asynchronously
func (client *Client) CreateABMetricWithChan(request *CreateABMetricRequest) (<-chan *CreateABMetricResponse, <-chan error) {
	responseChan := make(chan *CreateABMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateABMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateABMetricWithCallback invokes the pairecservice.CreateABMetric API asynchronously
func (client *Client) CreateABMetricWithCallback(request *CreateABMetricRequest, callback func(response *CreateABMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateABMetricResponse
		var err error
		defer close(result)
		response, err = client.CreateABMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateABMetricRequest is the request struct for api CreateABMetric
type CreateABMetricRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateABMetricResponse is the response struct for api CreateABMetric
type CreateABMetricResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ABMetricId string `json:"ABMetricId" xml:"ABMetricId"`
}

// CreateCreateABMetricRequest creates a request to invoke CreateABMetric API
func CreateCreateABMetricRequest() (request *CreateABMetricRequest) {
	request = &CreateABMetricRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateABMetric", "/api/v1/abmetrics", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateABMetricResponse creates a response to parse from CreateABMetric response
func CreateCreateABMetricResponse() (response *CreateABMetricResponse) {
	response = &CreateABMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
