package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDatasources invokes the paifeaturestore.ListDatasources API synchronously
func (client *Client) ListDatasources(request *ListDatasourcesRequest) (response *ListDatasourcesResponse, err error) {
	response = CreateListDatasourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatasourcesWithChan invokes the paifeaturestore.ListDatasources API asynchronously
func (client *Client) ListDatasourcesWithChan(request *ListDatasourcesRequest) (<-chan *ListDatasourcesResponse, <-chan error) {
	responseChan := make(chan *ListDatasourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDatasources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatasourcesWithCallback invokes the paifeaturestore.ListDatasources API asynchronously
func (client *Client) ListDatasourcesWithCallback(request *ListDatasourcesRequest, callback func(response *ListDatasourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatasourcesResponse
		var err error
		defer close(result)
		response, err = client.ListDatasources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatasourcesRequest is the request struct for api ListDatasources
type ListDatasourcesRequest struct {
	*requests.RoaRequest
	Type        string           `position:"Query" name:"Type"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId  string           `position:"Path" name:"InstanceId"`
	Name        string           `position:"Query" name:"Name"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	SortBy      string           `position:"Query" name:"SortBy"`
	WorkspaceId string           `position:"Query" name:"WorkspaceId"`
	Order       string           `position:"Query" name:"Order"`
}

// ListDatasourcesResponse is the response struct for api ListDatasources
type ListDatasourcesResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TotalCount  int64             `json:"TotalCount" xml:"TotalCount"`
	Datasources []DatasourcesItem `json:"Datasources" xml:"Datasources"`
}

// CreateListDatasourcesRequest creates a request to invoke ListDatasources API
func CreateListDatasourcesRequest() (request *ListDatasourcesRequest) {
	request = &ListDatasourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListDatasources", "/api/v1/instances/[InstanceId]/datasources", "", "")
	request.Method = requests.GET
	return
}

// CreateListDatasourcesResponse creates a response to parse from ListDatasources response
func CreateListDatasourcesResponse() (response *ListDatasourcesResponse) {
	response = &ListDatasourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
