package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOpsItem invokes the oos.CreateOpsItem API synchronously
func (client *Client) CreateOpsItem(request *CreateOpsItemRequest) (response *CreateOpsItemResponse, err error) {
	response = CreateCreateOpsItemResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOpsItemWithChan invokes the oos.CreateOpsItem API asynchronously
func (client *Client) CreateOpsItemWithChan(request *CreateOpsItemRequest) (<-chan *CreateOpsItemResponse, <-chan error) {
	responseChan := make(chan *CreateOpsItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOpsItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOpsItemWithCallback invokes the oos.CreateOpsItem API asynchronously
func (client *Client) CreateOpsItemWithCallback(request *CreateOpsItemRequest, callback func(response *CreateOpsItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOpsItemResponse
		var err error
		defer close(result)
		response, err = client.CreateOpsItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOpsItemRequest is the request struct for api CreateOpsItem
type CreateOpsItemRequest struct {
	*requests.RpcRequest
	ClientToken     string           `position:"Query" name:"ClientToken"`
	Description     string           `position:"Query" name:"Description"`
	Source          string           `position:"Query" name:"Source"`
	Title           string           `position:"Query" name:"Title"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	Severity        string           `position:"Query" name:"Severity"`
	Solutions       string           `position:"Query" name:"Solutions"`
	Resources       string           `position:"Query" name:"Resources"`
	Priority        requests.Integer `position:"Query" name:"Priority"`
	DedupString     string           `position:"Query" name:"DedupString"`
	Tags            string           `position:"Query" name:"Tags"`
	Category        string           `position:"Query" name:"Category"`
}

// CreateOpsItemResponse is the response struct for api CreateOpsItem
type CreateOpsItemResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	OpsItem   OpsItem `json:"OpsItem" xml:"OpsItem"`
}

// CreateCreateOpsItemRequest creates a request to invoke CreateOpsItem API
func CreateCreateOpsItemRequest() (request *CreateOpsItemRequest) {
	request = &CreateOpsItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "CreateOpsItem", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOpsItemResponse creates a response to parse from CreateOpsItem response
func CreateCreateOpsItemResponse() (response *CreateOpsItemResponse) {
	response = &CreateOpsItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
