package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsMessageTrace invokes the ons.OnsMessageTrace API synchronously
func (client *Client) OnsMessageTrace(request *OnsMessageTraceRequest) (response *OnsMessageTraceResponse, err error) {
	response = CreateOnsMessageTraceResponse()
	err = client.DoAction(request, response)
	return
}

// OnsMessageTraceWithChan invokes the ons.OnsMessageTrace API asynchronously
func (client *Client) OnsMessageTraceWithChan(request *OnsMessageTraceRequest) (<-chan *OnsMessageTraceResponse, <-chan error) {
	responseChan := make(chan *OnsMessageTraceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsMessageTrace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsMessageTraceWithCallback invokes the ons.OnsMessageTrace API asynchronously
func (client *Client) OnsMessageTraceWithCallback(request *OnsMessageTraceRequest, callback func(response *OnsMessageTraceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsMessageTraceResponse
		var err error
		defer close(result)
		response, err = client.OnsMessageTrace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsMessageTraceRequest is the request struct for api OnsMessageTrace
type OnsMessageTraceRequest struct {
	*requests.RpcRequest
	MsgId      string `position:"Query" name:"MsgId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Topic      string `position:"Query" name:"Topic"`
}

// OnsMessageTraceResponse is the response struct for api OnsMessageTrace
type OnsMessageTraceResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	HelpUrl   string                `json:"HelpUrl" xml:"HelpUrl"`
	Data      DataInOnsMessageTrace `json:"Data" xml:"Data"`
}

// CreateOnsMessageTraceRequest creates a request to invoke OnsMessageTrace API
func CreateOnsMessageTraceRequest() (request *OnsMessageTraceRequest) {
	request = &OnsMessageTraceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsMessageTrace", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsMessageTraceResponse creates a response to parse from OnsMessageTrace response
func CreateOnsMessageTraceResponse() (response *OnsMessageTraceResponse) {
	response = &OnsMessageTraceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
