package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseWorkerInstance invokes the oceanbasepro.ReleaseWorkerInstance API synchronously
func (client *Client) ReleaseWorkerInstance(request *ReleaseWorkerInstanceRequest) (response *ReleaseWorkerInstanceResponse, err error) {
	response = CreateReleaseWorkerInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseWorkerInstanceWithChan invokes the oceanbasepro.ReleaseWorkerInstance API asynchronously
func (client *Client) ReleaseWorkerInstanceWithChan(request *ReleaseWorkerInstanceRequest) (<-chan *ReleaseWorkerInstanceResponse, <-chan error) {
	responseChan := make(chan *ReleaseWorkerInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseWorkerInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseWorkerInstanceWithCallback invokes the oceanbasepro.ReleaseWorkerInstance API asynchronously
func (client *Client) ReleaseWorkerInstanceWithCallback(request *ReleaseWorkerInstanceRequest, callback func(response *ReleaseWorkerInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseWorkerInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReleaseWorkerInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseWorkerInstanceRequest is the request struct for api ReleaseWorkerInstance
type ReleaseWorkerInstanceRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// ReleaseWorkerInstanceResponse is the response struct for api ReleaseWorkerInstance
type ReleaseWorkerInstanceResponse struct {
	*responses.BaseResponse
}

// CreateReleaseWorkerInstanceRequest creates a request to invoke ReleaseWorkerInstance API
func CreateReleaseWorkerInstanceRequest() (request *ReleaseWorkerInstanceRequest) {
	request = &ReleaseWorkerInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ReleaseWorkerInstance", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseWorkerInstanceResponse creates a response to parse from ReleaseWorkerInstance response
func CreateReleaseWorkerInstanceResponse() (response *ReleaseWorkerInstanceResponse) {
	response = &ReleaseWorkerInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
