package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantEncryption invokes the oceanbasepro.ModifyTenantEncryption API synchronously
func (client *Client) ModifyTenantEncryption(request *ModifyTenantEncryptionRequest) (response *ModifyTenantEncryptionResponse, err error) {
	response = CreateModifyTenantEncryptionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantEncryptionWithChan invokes the oceanbasepro.ModifyTenantEncryption API asynchronously
func (client *Client) ModifyTenantEncryptionWithChan(request *ModifyTenantEncryptionRequest) (<-chan *ModifyTenantEncryptionResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantEncryptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantEncryption(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantEncryptionWithCallback invokes the oceanbasepro.ModifyTenantEncryption API asynchronously
func (client *Client) ModifyTenantEncryptionWithCallback(request *ModifyTenantEncryptionRequest, callback func(response *ModifyTenantEncryptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantEncryptionResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantEncryption(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantEncryptionRequest is the request struct for api ModifyTenantEncryption
type ModifyTenantEncryptionRequest struct {
	*requests.RpcRequest
	EncryptionKeyId string `position:"Body" name:"EncryptionKeyId"`
	InstanceId      string `position:"Body" name:"InstanceId"`
	TenantId        string `position:"Body" name:"TenantId"`
	EncryptionType  string `position:"Body" name:"EncryptionType"`
}

// ModifyTenantEncryptionResponse is the response struct for api ModifyTenantEncryption
type ModifyTenantEncryptionResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	TenantEncryption TenantEncryption `json:"TenantEncryption" xml:"TenantEncryption"`
}

// CreateModifyTenantEncryptionRequest creates a request to invoke ModifyTenantEncryption API
func CreateModifyTenantEncryptionRequest() (request *ModifyTenantEncryptionRequest) {
	request = &ModifyTenantEncryptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTenantEncryption", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantEncryptionResponse creates a response to parse from ModifyTenantEncryption response
func CreateModifyTenantEncryptionResponse() (response *ModifyTenantEncryptionResponse) {
	response = &ModifyTenantEncryptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
