package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantEncryption invokes the oceanbasepro.DescribeTenantEncryption API synchronously
func (client *Client) DescribeTenantEncryption(request *DescribeTenantEncryptionRequest) (response *DescribeTenantEncryptionResponse, err error) {
	response = CreateDescribeTenantEncryptionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantEncryptionWithChan invokes the oceanbasepro.DescribeTenantEncryption API asynchronously
func (client *Client) DescribeTenantEncryptionWithChan(request *DescribeTenantEncryptionRequest) (<-chan *DescribeTenantEncryptionResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantEncryptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantEncryption(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantEncryptionWithCallback invokes the oceanbasepro.DescribeTenantEncryption API asynchronously
func (client *Client) DescribeTenantEncryptionWithCallback(request *DescribeTenantEncryptionRequest, callback func(response *DescribeTenantEncryptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantEncryptionResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantEncryption(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantEncryptionRequest is the request struct for api DescribeTenantEncryption
type DescribeTenantEncryptionRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	TenantId   string           `position:"Body" name:"TenantId"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	TenantName string           `position:"Body" name:"TenantName"`
}

// DescribeTenantEncryptionResponse is the response struct for api DescribeTenantEncryption
type DescribeTenantEncryptionResponse struct {
	*responses.BaseResponse
	RequestId         string                  `json:"RequestId" xml:"RequestId"`
	TotalCount        int                     `json:"TotalCount" xml:"TotalCount"`
	TenantEncryptions []TenantEncryptionsItem `json:"TenantEncryptions" xml:"TenantEncryptions"`
}

// CreateDescribeTenantEncryptionRequest creates a request to invoke DescribeTenantEncryption API
func CreateDescribeTenantEncryptionRequest() (request *DescribeTenantEncryptionRequest) {
	request = &DescribeTenantEncryptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantEncryption", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantEncryptionResponse creates a response to parse from DescribeTenantEncryption response
func CreateDescribeTenantEncryptionResponse() (response *DescribeTenantEncryptionResponse) {
	response = &DescribeTenantEncryptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
