package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOasAnomalySQLList invokes the oceanbasepro.DescribeOasAnomalySQLList API synchronously
func (client *Client) DescribeOasAnomalySQLList(request *DescribeOasAnomalySQLListRequest) (response *DescribeOasAnomalySQLListResponse, err error) {
	response = CreateDescribeOasAnomalySQLListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOasAnomalySQLListWithChan invokes the oceanbasepro.DescribeOasAnomalySQLList API asynchronously
func (client *Client) DescribeOasAnomalySQLListWithChan(request *DescribeOasAnomalySQLListRequest) (<-chan *DescribeOasAnomalySQLListResponse, <-chan error) {
	responseChan := make(chan *DescribeOasAnomalySQLListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOasAnomalySQLList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOasAnomalySQLListWithCallback invokes the oceanbasepro.DescribeOasAnomalySQLList API asynchronously
func (client *Client) DescribeOasAnomalySQLListWithCallback(request *DescribeOasAnomalySQLListRequest, callback func(response *DescribeOasAnomalySQLListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOasAnomalySQLListResponse
		var err error
		defer close(result)
		response, err = client.DescribeOasAnomalySQLList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOasAnomalySQLListRequest is the request struct for api DescribeOasAnomalySQLList
type DescribeOasAnomalySQLListRequest struct {
	*requests.RpcRequest
	StartTime       string           `position:"Body" name:"StartTime"`
	SearchRule      string           `position:"Body" name:"SearchRule"`
	MergeDynamicSql requests.Boolean `position:"Body" name:"MergeDynamicSql"`
	Current         requests.Integer `position:"Body" name:"Current"`
	DynamicSql      requests.Boolean `position:"Body" name:"DynamicSql"`
	SqlTextLength   requests.Integer `position:"Body" name:"SqlTextLength"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	SearchValue     string           `position:"Body" name:"SearchValue"`
	SqlId           string           `position:"Body" name:"SqlId"`
	FilterCondition string           `position:"Body" name:"FilterCondition"`
	SearchParam     string           `position:"Body" name:"SearchParam"`
	EndTime         string           `position:"Body" name:"EndTime"`
	NodeIp          string           `position:"Body" name:"NodeIp"`
	InstanceId      string           `position:"Body" name:"InstanceId"`
	DbName          string           `position:"Body" name:"DbName"`
	SearchKeyWord   string           `position:"Body" name:"SearchKeyWord"`
	AcceptLanguage  string           `position:"Body" name:"AcceptLanguage"`
}

// DescribeOasAnomalySQLListResponse is the response struct for api DescribeOasAnomalySQLList
type DescribeOasAnomalySQLListResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int64      `json:"TotalCount" xml:"TotalCount"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeOasAnomalySQLListRequest creates a request to invoke DescribeOasAnomalySQLList API
func CreateDescribeOasAnomalySQLListRequest() (request *DescribeOasAnomalySQLListRequest) {
	request = &DescribeOasAnomalySQLListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOasAnomalySQLList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOasAnomalySQLListResponse creates a response to parse from DescribeOasAnomalySQLList response
func CreateDescribeOasAnomalySQLListResponse() (response *DescribeOasAnomalySQLListResponse) {
	response = &DescribeOasAnomalySQLListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
