package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTagValue invokes the oceanbasepro.CreateTagValue API synchronously
func (client *Client) CreateTagValue(request *CreateTagValueRequest) (response *CreateTagValueResponse, err error) {
	response = CreateCreateTagValueResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTagValueWithChan invokes the oceanbasepro.CreateTagValue API asynchronously
func (client *Client) CreateTagValueWithChan(request *CreateTagValueRequest) (<-chan *CreateTagValueResponse, <-chan error) {
	responseChan := make(chan *CreateTagValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTagValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTagValueWithCallback invokes the oceanbasepro.CreateTagValue API asynchronously
func (client *Client) CreateTagValueWithCallback(request *CreateTagValueRequest, callback func(response *CreateTagValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTagValueResponse
		var err error
		defer close(result)
		response, err = client.CreateTagValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTagValueRequest is the request struct for api CreateTagValue
type CreateTagValueRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Body" name:"ClientToken"`
	Value       string `position:"Body" name:"Value"`
	Key         string `position:"Body" name:"Key"`
}

// CreateTagValueResponse is the response struct for api CreateTagValue
type CreateTagValueResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTagValueRequest creates a request to invoke CreateTagValue API
func CreateCreateTagValueRequest() (request *CreateTagValueRequest) {
	request = &CreateTagValueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateTagValue", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTagValueResponse creates a response to parse from CreateTagValue response
func CreateCreateTagValueResponse() (response *CreateTagValueResponse) {
	response = &CreateTagValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
