package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferGroup invokes the oam.TransferGroup API synchronously
// api document: https://help.aliyun.com/api/oam/transfergroup.html
func (client *Client) TransferGroup(request *TransferGroupRequest) (response *TransferGroupResponse, err error) {
	response = CreateTransferGroupResponse()
	err = client.DoAction(request, response)
	return
}

// TransferGroupWithChan invokes the oam.TransferGroup API asynchronously
// api document: https://help.aliyun.com/api/oam/transfergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransferGroupWithChan(request *TransferGroupRequest) (<-chan *TransferGroupResponse, <-chan error) {
	responseChan := make(chan *TransferGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferGroupWithCallback invokes the oam.TransferGroup API asynchronously
// api document: https://help.aliyun.com/api/oam/transfergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TransferGroupWithCallback(request *TransferGroupRequest, callback func(response *TransferGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferGroupResponse
		var err error
		defer close(result)
		response, err = client.TransferGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferGroupRequest is the request struct for api TransferGroup
type TransferGroupRequest struct {
	*requests.RpcRequest
	GroupName string `position:"Query" name:"GroupName"`
	UserName  string `position:"Query" name:"UserName"`
}

// TransferGroupResponse is the response struct for api TransferGroup
type TransferGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateTransferGroupRequest creates a request to invoke TransferGroup API
func CreateTransferGroupRequest() (request *TransferGroupRequest) {
	request = &TransferGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "TransferGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateTransferGroupResponse creates a response to parse from TransferGroup response
func CreateTransferGroupResponse() (response *TransferGroupResponse) {
	response = &TransferGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
