package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNisNetworkMetrics invokes the nis.GetNisNetworkMetrics API synchronously
func (client *Client) GetNisNetworkMetrics(request *GetNisNetworkMetricsRequest) (response *GetNisNetworkMetricsResponse, err error) {
	response = CreateGetNisNetworkMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// GetNisNetworkMetricsWithChan invokes the nis.GetNisNetworkMetrics API asynchronously
func (client *Client) GetNisNetworkMetricsWithChan(request *GetNisNetworkMetricsRequest) (<-chan *GetNisNetworkMetricsResponse, <-chan error) {
	responseChan := make(chan *GetNisNetworkMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNisNetworkMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNisNetworkMetricsWithCallback invokes the nis.GetNisNetworkMetrics API asynchronously
func (client *Client) GetNisNetworkMetricsWithCallback(request *GetNisNetworkMetricsRequest, callback func(response *GetNisNetworkMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNisNetworkMetricsResponse
		var err error
		defer close(result)
		response, err = client.GetNisNetworkMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNisNetworkMetricsRequest is the request struct for api GetNisNetworkMetrics
type GetNisNetworkMetricsRequest struct {
	*requests.RpcRequest
	UseCrossAccount requests.Boolean                  `position:"Query" name:"UseCrossAccount"`
	ScanBy          string                            `position:"Query" name:"ScanBy"`
	MetricName      string                            `position:"Query" name:"MetricName"`
	EndTime         requests.Integer                  `position:"Query" name:"EndTime"`
	BeginTime       requests.Integer                  `position:"Query" name:"BeginTime"`
	ResourceType    string                            `position:"Query" name:"ResourceType"`
	RegionNo        string                            `position:"Query" name:"RegionNo"`
	AccountIds      *[]string                         `position:"Query" name:"AccountIds"  type:"Repeated"`
	Dimensions      *[]GetNisNetworkMetricsDimensions `position:"Query" name:"Dimensions"  type:"Json"`
}

// GetNisNetworkMetricsDimensions is a repeated param struct in GetNisNetworkMetricsRequest
type GetNisNetworkMetricsDimensions struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// GetNisNetworkMetricsResponse is the response struct for api GetNisNetworkMetrics
type GetNisNetworkMetricsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetNisNetworkMetricsRequest creates a request to invoke GetNisNetworkMetrics API
func CreateGetNisNetworkMetricsRequest() (request *GetNisNetworkMetricsRequest) {
	request = &GetNisNetworkMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetNisNetworkMetrics", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNisNetworkMetricsResponse creates a response to parse from GetNisNetworkMetrics response
func CreateGetNisNetworkMetricsResponse() (response *GetNisNetworkMetricsResponse) {
	response = &GetNisNetworkMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
