package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNatTopN invokes the nis.GetNatTopN API synchronously
func (client *Client) GetNatTopN(request *GetNatTopNRequest) (response *GetNatTopNResponse, err error) {
	response = CreateGetNatTopNResponse()
	err = client.DoAction(request, response)
	return
}

// GetNatTopNWithChan invokes the nis.GetNatTopN API asynchronously
func (client *Client) GetNatTopNWithChan(request *GetNatTopNRequest) (<-chan *GetNatTopNResponse, <-chan error) {
	responseChan := make(chan *GetNatTopNResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNatTopN(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNatTopNWithCallback invokes the nis.GetNatTopN API asynchronously
func (client *Client) GetNatTopNWithCallback(request *GetNatTopNRequest, callback func(response *GetNatTopNResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNatTopNResponse
		var err error
		defer close(result)
		response, err = client.GetNatTopN(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNatTopNRequest is the request struct for api GetNatTopN
type GetNatTopNRequest struct {
	*requests.RpcRequest
	Ip           string           `position:"Query" name:"Ip"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	OrderBy      string           `position:"Query" name:"OrderBy"`
	BeginTime    requests.Integer `position:"Query" name:"BeginTime"`
	TopN         requests.Integer `position:"Query" name:"TopN"`
	NatGatewayId string           `position:"Query" name:"NatGatewayId"`
}

// GetNatTopNResponse is the response struct for api GetNatTopN
type GetNatTopNResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	IsTopNOpen     bool                 `json:"IsTopNOpen" xml:"IsTopNOpen"`
	NatGatewayTopN []NatGatewayTopNItem `json:"NatGatewayTopN" xml:"NatGatewayTopN"`
}

// CreateGetNatTopNRequest creates a request to invoke GetNatTopN API
func CreateGetNatTopNRequest() (request *GetNatTopNRequest) {
	request = &GetNatTopNRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetNatTopN", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNatTopNResponse creates a response to parse from GetNatTopN response
func CreateGetNatTopNResponse() (response *GetNatTopNResponse) {
	response = &GetNatTopNResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
