package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDataFlow invokes the nas.StopDataFlow API synchronously
func (client *Client) StopDataFlow(request *StopDataFlowRequest) (response *StopDataFlowResponse, err error) {
	response = CreateStopDataFlowResponse()
	err = client.DoAction(request, response)
	return
}

// StopDataFlowWithChan invokes the nas.StopDataFlow API asynchronously
func (client *Client) StopDataFlowWithChan(request *StopDataFlowRequest) (<-chan *StopDataFlowResponse, <-chan error) {
	responseChan := make(chan *StopDataFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDataFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDataFlowWithCallback invokes the nas.StopDataFlow API asynchronously
func (client *Client) StopDataFlowWithCallback(request *StopDataFlowRequest, callback func(response *StopDataFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDataFlowResponse
		var err error
		defer close(result)
		response, err = client.StopDataFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDataFlowRequest is the request struct for api StopDataFlow
type StopDataFlowRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query" name:"ClientToken"`
	FileSystemId string           `position:"Query" name:"FileSystemId"`
	DryRun       requests.Boolean `position:"Query" name:"DryRun"`
	DataFlowId   string           `position:"Query" name:"DataFlowId"`
}

// StopDataFlowResponse is the response struct for api StopDataFlow
type StopDataFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDataFlowRequest creates a request to invoke StopDataFlow API
func CreateStopDataFlowRequest() (request *StopDataFlowRequest) {
	request = &StopDataFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "StopDataFlow", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDataFlowResponse creates a response to parse from StopDataFlow response
func CreateStopDataFlowResponse() (response *StopDataFlowResponse) {
	response = &StopDataFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
