package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomView invokes the mts.DeleteCustomView API synchronously
func (client *Client) DeleteCustomView(request *DeleteCustomViewRequest) (response *DeleteCustomViewResponse, err error) {
	response = CreateDeleteCustomViewResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomViewWithChan invokes the mts.DeleteCustomView API asynchronously
func (client *Client) DeleteCustomViewWithChan(request *DeleteCustomViewRequest) (<-chan *DeleteCustomViewResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomViewWithCallback invokes the mts.DeleteCustomView API asynchronously
func (client *Client) DeleteCustomViewWithCallback(request *DeleteCustomViewRequest, callback func(response *DeleteCustomViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomViewResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomViewRequest is the request struct for api DeleteCustomView
type DeleteCustomViewRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CustomViewId         string           `position:"Query" name:"CustomViewId"`
	Algorithm            string           `position:"Query" name:"Algorithm"`
	CustomGroupId        string           `position:"Query" name:"CustomGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CustomEntityId       string           `position:"Query" name:"CustomEntityId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCustomViewResponse is the response struct for api DeleteCustomView
type DeleteCustomViewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomViewRequest creates a request to invoke DeleteCustomView API
func CreateDeleteCustomViewRequest() (request *DeleteCustomViewRequest) {
	request = &DeleteCustomViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "DeleteCustomView", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomViewResponse creates a response to parse from DeleteCustomView response
func CreateDeleteCustomViewResponse() (response *DeleteCustomViewResponse) {
	response = &DeleteCustomViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
