package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSentinelBlockFallbackDefinitions invokes the mse.ListSentinelBlockFallbackDefinitions API synchronously
func (client *Client) ListSentinelBlockFallbackDefinitions(request *ListSentinelBlockFallbackDefinitionsRequest) (response *ListSentinelBlockFallbackDefinitionsResponse, err error) {
	response = CreateListSentinelBlockFallbackDefinitionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSentinelBlockFallbackDefinitionsWithChan invokes the mse.ListSentinelBlockFallbackDefinitions API asynchronously
func (client *Client) ListSentinelBlockFallbackDefinitionsWithChan(request *ListSentinelBlockFallbackDefinitionsRequest) (<-chan *ListSentinelBlockFallbackDefinitionsResponse, <-chan error) {
	responseChan := make(chan *ListSentinelBlockFallbackDefinitionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSentinelBlockFallbackDefinitions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSentinelBlockFallbackDefinitionsWithCallback invokes the mse.ListSentinelBlockFallbackDefinitions API asynchronously
func (client *Client) ListSentinelBlockFallbackDefinitionsWithCallback(request *ListSentinelBlockFallbackDefinitionsRequest, callback func(response *ListSentinelBlockFallbackDefinitionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSentinelBlockFallbackDefinitionsResponse
		var err error
		defer close(result)
		response, err = client.ListSentinelBlockFallbackDefinitions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSentinelBlockFallbackDefinitionsRequest is the request struct for api ListSentinelBlockFallbackDefinitions
type ListSentinelBlockFallbackDefinitionsRequest struct {
	*requests.RpcRequest
	MseSessionId      string    `position:"Query" name:"MseSessionId"`
	AppName           string    `position:"Query" name:"AppName"`
	ClassificationSet *[]string `position:"Query" name:"ClassificationSet"  type:"Json"`
	Namespace         string    `position:"Query" name:"Namespace"`
	AcceptLanguage    string    `position:"Query" name:"AcceptLanguage"`
}

// ListSentinelBlockFallbackDefinitionsResponse is the response struct for api ListSentinelBlockFallbackDefinitions
type ListSentinelBlockFallbackDefinitionsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string      `json:"Message" xml:"Message"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Data           []Fallbacks `json:"Data" xml:"Data"`
}

// CreateListSentinelBlockFallbackDefinitionsRequest creates a request to invoke ListSentinelBlockFallbackDefinitions API
func CreateListSentinelBlockFallbackDefinitionsRequest() (request *ListSentinelBlockFallbackDefinitionsRequest) {
	request = &ListSentinelBlockFallbackDefinitionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListSentinelBlockFallbackDefinitions", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSentinelBlockFallbackDefinitionsResponse creates a response to parse from ListSentinelBlockFallbackDefinitions response
func CreateListSentinelBlockFallbackDefinitionsResponse() (response *ListSentinelBlockFallbackDefinitionsResponse) {
	response = &ListSentinelBlockFallbackDefinitionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
