package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportZookeeperData invokes the mse.ImportZookeeperData API synchronously
func (client *Client) ImportZookeeperData(request *ImportZookeeperDataRequest) (response *ImportZookeeperDataResponse, err error) {
	response = CreateImportZookeeperDataResponse()
	err = client.DoAction(request, response)
	return
}

// ImportZookeeperDataWithChan invokes the mse.ImportZookeeperData API asynchronously
func (client *Client) ImportZookeeperDataWithChan(request *ImportZookeeperDataRequest) (<-chan *ImportZookeeperDataResponse, <-chan error) {
	responseChan := make(chan *ImportZookeeperDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportZookeeperData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportZookeeperDataWithCallback invokes the mse.ImportZookeeperData API asynchronously
func (client *Client) ImportZookeeperDataWithCallback(request *ImportZookeeperDataRequest, callback func(response *ImportZookeeperDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportZookeeperDataResponse
		var err error
		defer close(result)
		response, err = client.ImportZookeeperData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportZookeeperDataRequest is the request struct for api ImportZookeeperData
type ImportZookeeperDataRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	RequestPars    string `position:"Query" name:"RequestPars"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	FileName       string `position:"Query" name:"FileName"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	FileUrl        string `position:"Query" name:"FileUrl"`
}

// ImportZookeeperDataResponse is the response struct for api ImportZookeeperData
type ImportZookeeperDataResponse struct {
	*responses.BaseResponse
}

// CreateImportZookeeperDataRequest creates a request to invoke ImportZookeeperData API
func CreateImportZookeeperDataRequest() (request *ImportZookeeperDataRequest) {
	request = &ImportZookeeperDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ImportZookeeperData", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportZookeeperDataResponse creates a response to parse from ImportZookeeperData response
func CreateImportZookeeperDataResponse() (response *ImportZookeeperDataResponse) {
	response = &ImportZookeeperDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
