package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FetchLosslessRuleList invokes the mse.FetchLosslessRuleList API synchronously
func (client *Client) FetchLosslessRuleList(request *FetchLosslessRuleListRequest) (response *FetchLosslessRuleListResponse, err error) {
	response = CreateFetchLosslessRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// FetchLosslessRuleListWithChan invokes the mse.FetchLosslessRuleList API asynchronously
func (client *Client) FetchLosslessRuleListWithChan(request *FetchLosslessRuleListRequest) (<-chan *FetchLosslessRuleListResponse, <-chan error) {
	responseChan := make(chan *FetchLosslessRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FetchLosslessRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FetchLosslessRuleListWithCallback invokes the mse.FetchLosslessRuleList API asynchronously
func (client *Client) FetchLosslessRuleListWithCallback(request *FetchLosslessRuleListRequest, callback func(response *FetchLosslessRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FetchLosslessRuleListResponse
		var err error
		defer close(result)
		response, err = client.FetchLosslessRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FetchLosslessRuleListRequest is the request struct for api FetchLosslessRuleList
type FetchLosslessRuleListRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	AppName        string           `position:"Query" name:"AppName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AppId          string           `position:"Query" name:"AppId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// FetchLosslessRuleListResponse is the response struct for api FetchLosslessRuleList
type FetchLosslessRuleListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateFetchLosslessRuleListRequest creates a request to invoke FetchLosslessRuleList API
func CreateFetchLosslessRuleListRequest() (request *FetchLosslessRuleListRequest) {
	request = &FetchLosslessRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "FetchLosslessRuleList", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFetchLosslessRuleListResponse creates a response to parse from FetchLosslessRuleList response
func CreateFetchLosslessRuleListResponse() (response *FetchLosslessRuleListResponse) {
	response = &FetchLosslessRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
