package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGatewayAuth invokes the mse.AddGatewayAuth API synchronously
func (client *Client) AddGatewayAuth(request *AddGatewayAuthRequest) (response *AddGatewayAuthResponse, err error) {
	response = CreateAddGatewayAuthResponse()
	err = client.DoAction(request, response)
	return
}

// AddGatewayAuthWithChan invokes the mse.AddGatewayAuth API asynchronously
func (client *Client) AddGatewayAuthWithChan(request *AddGatewayAuthRequest) (<-chan *AddGatewayAuthResponse, <-chan error) {
	responseChan := make(chan *AddGatewayAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGatewayAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGatewayAuthWithCallback invokes the mse.AddGatewayAuth API asynchronously
func (client *Client) AddGatewayAuthWithCallback(request *AddGatewayAuthRequest, callback func(response *AddGatewayAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGatewayAuthResponse
		var err error
		defer close(result)
		response, err = client.AddGatewayAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGatewayAuthRequest is the request struct for api AddGatewayAuth
type AddGatewayAuthRequest struct {
	*requests.RpcRequest
	MseSessionId       string                            `position:"Query" name:"MseSessionId"`
	ClientId           string                            `position:"Query" name:"ClientId"`
	Type               string                            `position:"Query" name:"Type"`
	ScopesList         *[]string                         `position:"Query" name:"ScopesList"  type:"Json"`
	Issuer             string                            `position:"Query" name:"Issuer"`
	AuthResourceMode   requests.Integer                  `position:"Query" name:"AuthResourceMode"`
	Name               string                            `position:"Query" name:"Name"`
	AuthResourceConfig string                            `position:"Query" name:"AuthResourceConfig"`
	AuthResourceList   *[]AddGatewayAuthAuthResourceList `position:"Query" name:"AuthResourceList"  type:"Json"`
	Status             requests.Boolean                  `position:"Query" name:"Status"`
	Sub                string                            `position:"Query" name:"Sub"`
	Jwks               string                            `position:"Query" name:"Jwks"`
	GatewayUniqueId    string                            `position:"Query" name:"GatewayUniqueId"`
	TokenPosition      string                            `position:"Query" name:"TokenPosition"`
	IsWhite            requests.Boolean                  `position:"Query" name:"IsWhite"`
	CookieDomain       string                            `position:"Query" name:"CookieDomain"`
	ExternalAuthZJSON  AddGatewayAuthExternalAuthZJSON   `position:"Query" name:"ExternalAuthZJSON"  type:"Struct"`
	RedirectUrl        string                            `position:"Query" name:"RedirectUrl"`
	ClientSecret       string                            `position:"Query" name:"ClientSecret"`
	TokenNamePrefix    string                            `position:"Query" name:"TokenNamePrefix"`
	TokenPass          requests.Boolean                  `position:"Query" name:"TokenPass"`
	LoginUrl           string                            `position:"Query" name:"LoginUrl"`
	AcceptLanguage     string                            `position:"Query" name:"AcceptLanguage"`
	TokenName          string                            `position:"Query" name:"TokenName"`
}

// AddGatewayAuthAuthResourceList is a repeated param struct in AddGatewayAuthRequest
type AddGatewayAuthAuthResourceList struct {
	Path                   string                                                      `name:"Path"`
	IgnoreCase             string                                                      `name:"IgnoreCase"`
	AuthResourceHeaderList *[]AddGatewayAuthAuthResourceListAuthResourceHeaderListItem `name:"AuthResourceHeaderList" type:"Repeated"`
	MatchType              string                                                      `name:"MatchType"`
	DomainId               string                                                      `name:"DomainId"`
}

// AddGatewayAuthAuthResourceListAuthResourceHeaderListItem is a repeated param struct in AddGatewayAuthRequest
type AddGatewayAuthAuthResourceListAuthResourceHeaderListItem struct {
	HeaderValue  string `name:"HeaderValue"`
	HeaderMethod string `name:"HeaderMethod"`
	HeaderKey    string `name:"HeaderKey"`
}

// AddGatewayAuthExternalAuthZJSON is a repeated param struct in AddGatewayAuthRequest
type AddGatewayAuthExternalAuthZJSON struct {
	TokenKey             string    `name:"TokenKey"`
	AllowUpstreamHeaders *[]string `name:"AllowUpstreamHeaders" type:"Repeated"`
	WithRequestBody      string    `name:"WithRequestBody"`
	WithRematchRoute     string    `name:"WithRematchRoute"`
	BodyMaxBytes         string    `name:"BodyMaxBytes"`
	IsRestrict           string    `name:"IsRestrict"`
	ServiceId            string    `name:"ServiceId"`
	AllowRequestHeaders  *[]string `name:"AllowRequestHeaders" type:"Repeated"`
	PrefixPath           string    `name:"PrefixPath"`
	Timeout              string    `name:"Timeout"`
}

// AddGatewayAuthResponse is the response struct for api AddGatewayAuth
type AddGatewayAuthResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddGatewayAuthRequest creates a request to invoke AddGatewayAuth API
func CreateAddGatewayAuthRequest() (request *AddGatewayAuthRequest) {
	request = &AddGatewayAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddGatewayAuth", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGatewayAuthResponse creates a response to parse from AddGatewayAuth response
func CreateAddGatewayAuthResponse() (response *AddGatewayAuthResponse) {
	response = &AddGatewayAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
