package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenApiEncode invokes the mpaas.OpenApiEncode API synchronously
func (client *Client) OpenApiEncode(request *OpenApiEncodeRequest) (response *OpenApiEncodeResponse, err error) {
	response = CreateOpenApiEncodeResponse()
	err = client.DoAction(request, response)
	return
}

// OpenApiEncodeWithChan invokes the mpaas.OpenApiEncode API asynchronously
func (client *Client) OpenApiEncodeWithChan(request *OpenApiEncodeRequest) (<-chan *OpenApiEncodeResponse, <-chan error) {
	responseChan := make(chan *OpenApiEncodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenApiEncode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenApiEncodeWithCallback invokes the mpaas.OpenApiEncode API asynchronously
func (client *Client) OpenApiEncodeWithCallback(request *OpenApiEncodeRequest, callback func(response *OpenApiEncodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenApiEncodeResponse
		var err error
		defer close(result)
		response, err = client.OpenApiEncode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenApiEncodeRequest is the request struct for api OpenApiEncode
type OpenApiEncodeRequest struct {
	*requests.RpcRequest
	TenantId                             string `position:"Body" name:"TenantId"`
	MpaasMqcpOpenApiEncodeRequestJsonStr string `position:"Body" name:"MpaasMqcpOpenApiEncodeRequestJsonStr"`
	AppId                                string `position:"Body" name:"AppId"`
	WorkspaceId                          string `position:"Body" name:"WorkspaceId"`
}

// OpenApiEncodeResponse is the response struct for api OpenApiEncode
type OpenApiEncodeResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
}

// CreateOpenApiEncodeRequest creates a request to invoke OpenApiEncode API
func CreateOpenApiEncodeRequest() (request *OpenApiEncodeRequest) {
	request = &OpenApiEncodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "OpenApiEncode", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenApiEncodeResponse creates a response to parse from OpenApiEncode response
func CreateOpenApiEncodeResponse() (response *OpenApiEncodeResponse) {
	response = &OpenApiEncodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
