package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMsacProductVersion invokes the mpaas.GetMsacProductVersion API synchronously
func (client *Client) GetMsacProductVersion(request *GetMsacProductVersionRequest) (response *GetMsacProductVersionResponse, err error) {
	response = CreateGetMsacProductVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetMsacProductVersionWithChan invokes the mpaas.GetMsacProductVersion API asynchronously
func (client *Client) GetMsacProductVersionWithChan(request *GetMsacProductVersionRequest) (<-chan *GetMsacProductVersionResponse, <-chan error) {
	responseChan := make(chan *GetMsacProductVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMsacProductVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMsacProductVersionWithCallback invokes the mpaas.GetMsacProductVersion API asynchronously
func (client *Client) GetMsacProductVersionWithCallback(request *GetMsacProductVersionRequest, callback func(response *GetMsacProductVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMsacProductVersionResponse
		var err error
		defer close(result)
		response, err = client.GetMsacProductVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMsacProductVersionRequest is the request struct for api GetMsacProductVersion
type GetMsacProductVersionRequest struct {
	*requests.RpcRequest
	Platform    string `position:"Body" name:"Platform"`
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// GetMsacProductVersionResponse is the response struct for api GetMsacProductVersion
type GetMsacProductVersionResponse struct {
	*responses.BaseResponse
	ResultMessage string                               `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                               `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                               `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInGetMsacProductVersion `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetMsacProductVersionRequest creates a request to invoke GetMsacProductVersion API
func CreateGetMsacProductVersionRequest() (request *GetMsacProductVersionRequest) {
	request = &GetMsacProductVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMsacProductVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMsacProductVersionResponse creates a response to parse from GetMsacProductVersion response
func CreateGetMsacProductVersionResponse() (response *GetMsacProductVersionResponse) {
	response = &GetMsacProductVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
