package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcdpEventAttributeById invokes the mpaas.DeleteMcdpEventAttributeById API synchronously
func (client *Client) DeleteMcdpEventAttributeById(request *DeleteMcdpEventAttributeByIdRequest) (response *DeleteMcdpEventAttributeByIdResponse, err error) {
	response = CreateDeleteMcdpEventAttributeByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcdpEventAttributeByIdWithChan invokes the mpaas.DeleteMcdpEventAttributeById API asynchronously
func (client *Client) DeleteMcdpEventAttributeByIdWithChan(request *DeleteMcdpEventAttributeByIdRequest) (<-chan *DeleteMcdpEventAttributeByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteMcdpEventAttributeByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcdpEventAttributeById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcdpEventAttributeByIdWithCallback invokes the mpaas.DeleteMcdpEventAttributeById API asynchronously
func (client *Client) DeleteMcdpEventAttributeByIdWithCallback(request *DeleteMcdpEventAttributeByIdRequest, callback func(response *DeleteMcdpEventAttributeByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcdpEventAttributeByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcdpEventAttributeById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcdpEventAttributeByIdRequest is the request struct for api DeleteMcdpEventAttributeById
type DeleteMcdpEventAttributeByIdRequest struct {
	*requests.RpcRequest
	TenantId                                       string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpEventAttributeDeleteJsonStr string `position:"Body" name:"MpaasMappcenterMcdpEventAttributeDeleteJsonStr"`
	AppId                                          string `position:"Body" name:"AppId"`
	WorkspaceId                                    string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcdpEventAttributeByIdResponse is the response struct for api DeleteMcdpEventAttributeById
type DeleteMcdpEventAttributeByIdResponse struct {
	*responses.BaseResponse
	ResultMessage string                                      `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                      `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                      `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMcdpEventAttributeById `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMcdpEventAttributeByIdRequest creates a request to invoke DeleteMcdpEventAttributeById API
func CreateDeleteMcdpEventAttributeByIdRequest() (request *DeleteMcdpEventAttributeByIdRequest) {
	request = &DeleteMcdpEventAttributeByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcdpEventAttributeById", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcdpEventAttributeByIdResponse creates a response to parse from DeleteMcdpEventAttributeById response
func CreateDeleteMcdpEventAttributeByIdResponse() (response *DeleteMcdpEventAttributeByIdResponse) {
	response = &DeleteMcdpEventAttributeByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
