package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopyMcdpGroup invokes the mpaas.CopyMcdpGroup API synchronously
func (client *Client) CopyMcdpGroup(request *CopyMcdpGroupRequest) (response *CopyMcdpGroupResponse, err error) {
	response = CreateCopyMcdpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CopyMcdpGroupWithChan invokes the mpaas.CopyMcdpGroup API asynchronously
func (client *Client) CopyMcdpGroupWithChan(request *CopyMcdpGroupRequest) (<-chan *CopyMcdpGroupResponse, <-chan error) {
	responseChan := make(chan *CopyMcdpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopyMcdpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopyMcdpGroupWithCallback invokes the mpaas.CopyMcdpGroup API asynchronously
func (client *Client) CopyMcdpGroupWithCallback(request *CopyMcdpGroupRequest, callback func(response *CopyMcdpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopyMcdpGroupResponse
		var err error
		defer close(result)
		response, err = client.CopyMcdpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopyMcdpGroupRequest is the request struct for api CopyMcdpGroup
type CopyMcdpGroupRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMcdpGroupCopyJsonStr string `position:"Body" name:"MpaasMappcenterMcdpGroupCopyJsonStr"`
	TenantId                            string `position:"Body" name:"TenantId"`
	AppId                               string `position:"Body" name:"AppId"`
	WorkspaceId                         string `position:"Body" name:"WorkspaceId"`
}

// CopyMcdpGroupResponse is the response struct for api CopyMcdpGroup
type CopyMcdpGroupResponse struct {
	*responses.BaseResponse
	ResultMessage string                       `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                       `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                       `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCopyMcdpGroup `json:"ResultContent" xml:"ResultContent"`
}

// CreateCopyMcdpGroupRequest creates a request to invoke CopyMcdpGroup API
func CreateCopyMcdpGroupRequest() (request *CopyMcdpGroupRequest) {
	request = &CopyMcdpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CopyMcdpGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCopyMcdpGroupResponse creates a response to parse from CopyMcdpGroup response
func CreateCopyMcdpGroupResponse() (response *CopyMcdpGroupResponse) {
	response = &CopyMcdpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
