package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEdgeDeviceGroup invokes the lto.ListEdgeDeviceGroup API synchronously
func (client *Client) ListEdgeDeviceGroup(request *ListEdgeDeviceGroupRequest) (response *ListEdgeDeviceGroupResponse, err error) {
	response = CreateListEdgeDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListEdgeDeviceGroupWithChan invokes the lto.ListEdgeDeviceGroup API asynchronously
func (client *Client) ListEdgeDeviceGroupWithChan(request *ListEdgeDeviceGroupRequest) (<-chan *ListEdgeDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *ListEdgeDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEdgeDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEdgeDeviceGroupWithCallback invokes the lto.ListEdgeDeviceGroup API asynchronously
func (client *Client) ListEdgeDeviceGroupWithCallback(request *ListEdgeDeviceGroupRequest, callback func(response *ListEdgeDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEdgeDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.ListEdgeDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEdgeDeviceGroupRequest is the request struct for api ListEdgeDeviceGroup
type ListEdgeDeviceGroupRequest struct {
	*requests.RpcRequest
	Num    requests.Integer `position:"Query" name:"Num"`
	Size   requests.Integer `position:"Query" name:"Size"`
	Name   string           `position:"Query" name:"Name"`
	Status string           `position:"Query" name:"Status"`
}

// ListEdgeDeviceGroupResponse is the response struct for api ListEdgeDeviceGroup
type ListEdgeDeviceGroupResponse struct {
	*responses.BaseResponse
	Code           string                    `json:"Code" xml:"Code"`
	HttpStatusCode int                       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                    `json:"Message" xml:"Message"`
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	Success        bool                      `json:"Success" xml:"Success"`
	Data           DataInListEdgeDeviceGroup `json:"Data" xml:"Data"`
}

// CreateListEdgeDeviceGroupRequest creates a request to invoke ListEdgeDeviceGroup API
func CreateListEdgeDeviceGroupRequest() (request *ListEdgeDeviceGroupRequest) {
	request = &ListEdgeDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListEdgeDeviceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListEdgeDeviceGroupResponse creates a response to parse from ListEdgeDeviceGroup response
func CreateListEdgeDeviceGroupResponse() (response *ListEdgeDeviceGroupResponse) {
	response = &ListEdgeDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
