package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaaSAntChainConsortium invokes the lto.ListBaaSAntChainConsortium API synchronously
func (client *Client) ListBaaSAntChainConsortium(request *ListBaaSAntChainConsortiumRequest) (response *ListBaaSAntChainConsortiumResponse, err error) {
	response = CreateListBaaSAntChainConsortiumResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaaSAntChainConsortiumWithChan invokes the lto.ListBaaSAntChainConsortium API asynchronously
func (client *Client) ListBaaSAntChainConsortiumWithChan(request *ListBaaSAntChainConsortiumRequest) (<-chan *ListBaaSAntChainConsortiumResponse, <-chan error) {
	responseChan := make(chan *ListBaaSAntChainConsortiumResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaaSAntChainConsortium(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaaSAntChainConsortiumWithCallback invokes the lto.ListBaaSAntChainConsortium API asynchronously
func (client *Client) ListBaaSAntChainConsortiumWithCallback(request *ListBaaSAntChainConsortiumRequest, callback func(response *ListBaaSAntChainConsortiumResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaaSAntChainConsortiumResponse
		var err error
		defer close(result)
		response, err = client.ListBaaSAntChainConsortium(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaaSAntChainConsortiumRequest is the request struct for api ListBaaSAntChainConsortium
type ListBaaSAntChainConsortiumRequest struct {
	*requests.RpcRequest
}

// ListBaaSAntChainConsortiumResponse is the response struct for api ListBaaSAntChainConsortium
type ListBaaSAntChainConsortiumResponse struct {
	*responses.BaseResponse
	Code           string                       `json:"Code" xml:"Code"`
	HttpStatusCode int                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                       `json:"Message" xml:"Message"`
	RequestId      string                       `json:"RequestId" xml:"RequestId"`
	Success        bool                         `json:"Success" xml:"Success"`
	Data           []BaaSAntChainConsortiumInfo `json:"Data" xml:"Data"`
}

// CreateListBaaSAntChainConsortiumRequest creates a request to invoke ListBaaSAntChainConsortium API
func CreateListBaaSAntChainConsortiumRequest() (request *ListBaaSAntChainConsortiumRequest) {
	request = &ListBaaSAntChainConsortiumRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListBaaSAntChainConsortium", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaaSAntChainConsortiumResponse creates a response to parse from ListBaaSAntChainConsortium response
func CreateListBaaSAntChainConsortiumResponse() (response *ListBaaSAntChainConsortiumResponse) {
	response = &ListBaaSAntChainConsortiumResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
