package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AuthorizeMemberBizChain invokes the lto.AuthorizeMemberBizChain API synchronously
func (client *Client) AuthorizeMemberBizChain(request *AuthorizeMemberBizChainRequest) (response *AuthorizeMemberBizChainResponse, err error) {
	response = CreateAuthorizeMemberBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// AuthorizeMemberBizChainWithChan invokes the lto.AuthorizeMemberBizChain API asynchronously
func (client *Client) AuthorizeMemberBizChainWithChan(request *AuthorizeMemberBizChainRequest) (<-chan *AuthorizeMemberBizChainResponse, <-chan error) {
	responseChan := make(chan *AuthorizeMemberBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AuthorizeMemberBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AuthorizeMemberBizChainWithCallback invokes the lto.AuthorizeMemberBizChain API asynchronously
func (client *Client) AuthorizeMemberBizChainWithCallback(request *AuthorizeMemberBizChainRequest, callback func(response *AuthorizeMemberBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AuthorizeMemberBizChainResponse
		var err error
		defer close(result)
		response, err = client.AuthorizeMemberBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AuthorizeMemberBizChainRequest is the request struct for api AuthorizeMemberBizChain
type AuthorizeMemberBizChainRequest struct {
	*requests.RpcRequest
	BizChainInfo string `position:"Query" name:"BizChainInfo"`
	MemberId     string `position:"Query" name:"MemberId"`
}

// AuthorizeMemberBizChainResponse is the response struct for api AuthorizeMemberBizChain
type AuthorizeMemberBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAuthorizeMemberBizChainRequest creates a request to invoke AuthorizeMemberBizChain API
func CreateAuthorizeMemberBizChainRequest() (request *AuthorizeMemberBizChainRequest) {
	request = &AuthorizeMemberBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AuthorizeMemberBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateAuthorizeMemberBizChainResponse creates a response to parse from AuthorizeMemberBizChain response
func CreateAuthorizeMemberBizChainResponse() (response *AuthorizeMemberBizChainResponse) {
	response = &AuthorizeMemberBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
