package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetData invokes the ltl.GetData API synchronously
func (client *Client) GetData(request *GetDataRequest) (response *GetDataResponse, err error) {
	response = CreateGetDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataWithChan invokes the ltl.GetData API asynchronously
func (client *Client) GetDataWithChan(request *GetDataRequest) (<-chan *GetDataResponse, <-chan error) {
	responseChan := make(chan *GetDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataWithCallback invokes the ltl.GetData API asynchronously
func (client *Client) GetDataWithCallback(request *GetDataRequest, callback func(response *GetDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataResponse
		var err error
		defer close(result)
		response, err = client.GetData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataRequest is the request struct for api GetData
type GetDataRequest struct {
	*requests.RpcRequest
	BusinessId string `position:"Query" name:"BusinessId"`
	ApiVersion string `position:"Query" name:"ApiVersion"`
	ProductKey string `position:"Query" name:"ProductKey"`
	Key        string `position:"Query" name:"Key"`
}

// GetDataResponse is the response struct for api GetData
type GetDataResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetDataRequest creates a request to invoke GetData API
func CreateGetDataRequest() (request *GetDataRequest) {
	request = &GetDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "GetData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDataResponse creates a response to parse from GetData response
func CreateGetDataResponse() (response *GetDataResponse) {
	response = &GetDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
