package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUploadMPCoSPhaseTextInfoByDevice invokes the ltl.BatchUploadMPCoSPhaseTextInfoByDevice API synchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfoByDevice(request *BatchUploadMPCoSPhaseTextInfoByDeviceRequest) (response *BatchUploadMPCoSPhaseTextInfoByDeviceResponse, err error) {
	response = CreateBatchUploadMPCoSPhaseTextInfoByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUploadMPCoSPhaseTextInfoByDeviceWithChan invokes the ltl.BatchUploadMPCoSPhaseTextInfoByDevice API asynchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfoByDeviceWithChan(request *BatchUploadMPCoSPhaseTextInfoByDeviceRequest) (<-chan *BatchUploadMPCoSPhaseTextInfoByDeviceResponse, <-chan error) {
	responseChan := make(chan *BatchUploadMPCoSPhaseTextInfoByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUploadMPCoSPhaseTextInfoByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUploadMPCoSPhaseTextInfoByDeviceWithCallback invokes the ltl.BatchUploadMPCoSPhaseTextInfoByDevice API asynchronously
func (client *Client) BatchUploadMPCoSPhaseTextInfoByDeviceWithCallback(request *BatchUploadMPCoSPhaseTextInfoByDeviceRequest, callback func(response *BatchUploadMPCoSPhaseTextInfoByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUploadMPCoSPhaseTextInfoByDeviceResponse
		var err error
		defer close(result)
		response, err = client.BatchUploadMPCoSPhaseTextInfoByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUploadMPCoSPhaseTextInfoByDeviceRequest is the request struct for api BatchUploadMPCoSPhaseTextInfoByDevice
type BatchUploadMPCoSPhaseTextInfoByDeviceRequest struct {
	*requests.RpcRequest
	IotSignature         string                 `position:"Query" name:"IotSignature"`
	IotAuthType          string                 `position:"Query" name:"IotAuthType"`
	IotIdSource          string                 `position:"Query" name:"IotIdSource"`
	PhaseId              string                 `position:"Query" name:"PhaseId"`
	ApiVersion           string                 `position:"Query" name:"ApiVersion"`
	BizChainId           string                 `position:"Query" name:"BizChainId"`
	PhaseDataList        map[string]interface{} `position:"Query" name:"PhaseDataList"`
	IotId                string                 `position:"Query" name:"IotId"`
	PhaseGroupId         string                 `position:"Query" name:"PhaseGroupId"`
	IotDataDigest        string                 `position:"Query" name:"IotDataDigest"`
	IotIdServiceProvider string                 `position:"Query" name:"IotIdServiceProvider"`
}

// BatchUploadMPCoSPhaseTextInfoByDeviceResponse is the response struct for api BatchUploadMPCoSPhaseTextInfoByDevice
type BatchUploadMPCoSPhaseTextInfoByDeviceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBatchUploadMPCoSPhaseTextInfoByDeviceRequest creates a request to invoke BatchUploadMPCoSPhaseTextInfoByDevice API
func CreateBatchUploadMPCoSPhaseTextInfoByDeviceRequest() (request *BatchUploadMPCoSPhaseTextInfoByDeviceRequest) {
	request = &BatchUploadMPCoSPhaseTextInfoByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "BatchUploadMPCoSPhaseTextInfoByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUploadMPCoSPhaseTextInfoByDeviceResponse creates a response to parse from BatchUploadMPCoSPhaseTextInfoByDevice response
func CreateBatchUploadMPCoSPhaseTextInfoByDeviceResponse() (response *BatchUploadMPCoSPhaseTextInfoByDeviceResponse) {
	response = &BatchUploadMPCoSPhaseTextInfoByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
