package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopRtcAsrTask invokes the live.StopRtcAsrTask API synchronously
func (client *Client) StopRtcAsrTask(request *StopRtcAsrTaskRequest) (response *StopRtcAsrTaskResponse, err error) {
	response = CreateStopRtcAsrTaskResponse()
	err = client.DoAction(request, response)
	return
}

// StopRtcAsrTaskWithChan invokes the live.StopRtcAsrTask API asynchronously
func (client *Client) StopRtcAsrTaskWithChan(request *StopRtcAsrTaskRequest) (<-chan *StopRtcAsrTaskResponse, <-chan error) {
	responseChan := make(chan *StopRtcAsrTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopRtcAsrTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopRtcAsrTaskWithCallback invokes the live.StopRtcAsrTask API asynchronously
func (client *Client) StopRtcAsrTaskWithCallback(request *StopRtcAsrTaskRequest, callback func(response *StopRtcAsrTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopRtcAsrTaskResponse
		var err error
		defer close(result)
		response, err = client.StopRtcAsrTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopRtcAsrTaskRequest is the request struct for api StopRtcAsrTask
type StopRtcAsrTaskRequest struct {
	*requests.RpcRequest
	TaskId  string           `position:"Query" name:"TaskId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// StopRtcAsrTaskResponse is the response struct for api StopRtcAsrTask
type StopRtcAsrTaskResponse struct {
	*responses.BaseResponse
	Description string `json:"Description" xml:"Description"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RetCode     int64  `json:"RetCode" xml:"RetCode"`
}

// CreateStopRtcAsrTaskRequest creates a request to invoke StopRtcAsrTask API
func CreateStopRtcAsrTaskRequest() (request *StopRtcAsrTaskRequest) {
	request = &StopRtcAsrTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "StopRtcAsrTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopRtcAsrTaskResponse creates a response to parse from StopRtcAsrTask response
func CreateStopRtcAsrTaskResponse() (response *StopRtcAsrTaskResponse) {
	response = &StopRtcAsrTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
