package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLiveAIStudio invokes the live.ModifyLiveAIStudio API synchronously
func (client *Client) ModifyLiveAIStudio(request *ModifyLiveAIStudioRequest) (response *ModifyLiveAIStudioResponse, err error) {
	response = CreateModifyLiveAIStudioResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLiveAIStudioWithChan invokes the live.ModifyLiveAIStudio API asynchronously
func (client *Client) ModifyLiveAIStudioWithChan(request *ModifyLiveAIStudioRequest) (<-chan *ModifyLiveAIStudioResponse, <-chan error) {
	responseChan := make(chan *ModifyLiveAIStudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLiveAIStudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLiveAIStudioWithCallback invokes the live.ModifyLiveAIStudio API asynchronously
func (client *Client) ModifyLiveAIStudioWithCallback(request *ModifyLiveAIStudioRequest, callback func(response *ModifyLiveAIStudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLiveAIStudioResponse
		var err error
		defer close(result)
		response, err = client.ModifyLiveAIStudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLiveAIStudioRequest is the request struct for api ModifyLiveAIStudio
type ModifyLiveAIStudioRequest struct {
	*requests.RpcRequest
	BackgroundResourceId  string                          `position:"Query" name:"BackgroundResourceId"`
	Description           string                          `position:"Query" name:"Description"`
	MediaLayout           ModifyLiveAIStudioMediaLayout   `position:"Query" name:"MediaLayout"  type:"Struct"`
	BackgroundType        string                          `position:"Query" name:"BackgroundType"`
	MattingType           string                          `position:"Query" name:"MattingType"`
	MediaResourceUrl      string                          `position:"Query" name:"MediaResourceUrl"`
	Height                requests.Integer                `position:"Query" name:"Height"`
	BackgroundResourceUrl string                          `position:"Query" name:"BackgroundResourceUrl"`
	MediaResourceId       string                          `position:"Query" name:"MediaResourceId"`
	MattingLayout         ModifyLiveAIStudioMattingLayout `position:"Query" name:"MattingLayout"  type:"Struct"`
	OwnerId               requests.Integer                `position:"Query" name:"OwnerId"`
	StudioName            string                          `position:"Query" name:"StudioName"`
	Width                 requests.Integer                `position:"Query" name:"Width"`
	MediaType             string                          `position:"Query" name:"MediaType"`
}

// ModifyLiveAIStudioMediaLayout is a repeated param struct in ModifyLiveAIStudioRequest
type ModifyLiveAIStudioMediaLayout struct {
	PositionX        string `name:"PositionX"`
	PositionY        string `name:"PositionY"`
	HeightNormalized string `name:"HeightNormalized"`
}

// ModifyLiveAIStudioMattingLayout is a repeated param struct in ModifyLiveAIStudioRequest
type ModifyLiveAIStudioMattingLayout struct {
	PositionX        string `name:"PositionX"`
	PositionY        string `name:"PositionY"`
	HeightNormalized string `name:"HeightNormalized"`
}

// ModifyLiveAIStudioResponse is the response struct for api ModifyLiveAIStudio
type ModifyLiveAIStudioResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyLiveAIStudioRequest creates a request to invoke ModifyLiveAIStudio API
func CreateModifyLiveAIStudioRequest() (request *ModifyLiveAIStudioRequest) {
	request = &ModifyLiveAIStudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyLiveAIStudio", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyLiveAIStudioResponse creates a response to parse from ModifyLiveAIStudio response
func CreateModifyLiveAIStudioResponse() (response *ModifyLiveAIStudioResponse) {
	response = &ModifyLiveAIStudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
