package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLivePrivateLineAvailGA invokes the live.DescribeLivePrivateLineAvailGA API synchronously
func (client *Client) DescribeLivePrivateLineAvailGA(request *DescribeLivePrivateLineAvailGARequest) (response *DescribeLivePrivateLineAvailGAResponse, err error) {
	response = CreateDescribeLivePrivateLineAvailGAResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLivePrivateLineAvailGAWithChan invokes the live.DescribeLivePrivateLineAvailGA API asynchronously
func (client *Client) DescribeLivePrivateLineAvailGAWithChan(request *DescribeLivePrivateLineAvailGARequest) (<-chan *DescribeLivePrivateLineAvailGAResponse, <-chan error) {
	responseChan := make(chan *DescribeLivePrivateLineAvailGAResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLivePrivateLineAvailGA(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLivePrivateLineAvailGAWithCallback invokes the live.DescribeLivePrivateLineAvailGA API asynchronously
func (client *Client) DescribeLivePrivateLineAvailGAWithCallback(request *DescribeLivePrivateLineAvailGARequest, callback func(response *DescribeLivePrivateLineAvailGAResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLivePrivateLineAvailGAResponse
		var err error
		defer close(result)
		response, err = client.DescribeLivePrivateLineAvailGA(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLivePrivateLineAvailGARequest is the request struct for api DescribeLivePrivateLineAvailGA
type DescribeLivePrivateLineAvailGARequest struct {
	*requests.RpcRequest
	AccelerationArea string           `position:"Query" name:"AccelerationArea"`
	AppName          string           `position:"Query" name:"AppName"`
	StreamName       string           `position:"Query" name:"StreamName"`
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	VideoCenter      string           `position:"Query" name:"VideoCenter"`
	IsGaInstance     string           `position:"Query" name:"IsGaInstance"`
}

// DescribeLivePrivateLineAvailGAResponse is the response struct for api DescribeLivePrivateLineAvailGA
type DescribeLivePrivateLineAvailGAResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	LivePrivateLineAvailGAs LivePrivateLineAvailGAs `json:"LivePrivateLineAvailGAs" xml:"LivePrivateLineAvailGAs"`
}

// CreateDescribeLivePrivateLineAvailGARequest creates a request to invoke DescribeLivePrivateLineAvailGA API
func CreateDescribeLivePrivateLineAvailGARequest() (request *DescribeLivePrivateLineAvailGARequest) {
	request = &DescribeLivePrivateLineAvailGARequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLivePrivateLineAvailGA", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLivePrivateLineAvailGAResponse creates a response to parse from DescribeLivePrivateLineAvailGA response
func CreateDescribeLivePrivateLineAvailGAResponse() (response *DescribeLivePrivateLineAvailGAResponse) {
	response = &DescribeLivePrivateLineAvailGAResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
