package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveMessageUserMessage invokes the live.DeleteLiveMessageUserMessage API synchronously
func (client *Client) DeleteLiveMessageUserMessage(request *DeleteLiveMessageUserMessageRequest) (response *DeleteLiveMessageUserMessageResponse, err error) {
	response = CreateDeleteLiveMessageUserMessageResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveMessageUserMessageWithChan invokes the live.DeleteLiveMessageUserMessage API asynchronously
func (client *Client) DeleteLiveMessageUserMessageWithChan(request *DeleteLiveMessageUserMessageRequest) (<-chan *DeleteLiveMessageUserMessageResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveMessageUserMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveMessageUserMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveMessageUserMessageWithCallback invokes the live.DeleteLiveMessageUserMessage API asynchronously
func (client *Client) DeleteLiveMessageUserMessageWithCallback(request *DeleteLiveMessageUserMessageRequest, callback func(response *DeleteLiveMessageUserMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveMessageUserMessageResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveMessageUserMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveMessageUserMessageRequest is the request struct for api DeleteLiveMessageUserMessage
type DeleteLiveMessageUserMessageRequest struct {
	*requests.RpcRequest
	MessageId   string `position:"Query" name:"MessageId"`
	DataCenter  string `position:"Query" name:"DataCenter"`
	ReceiverId  string `position:"Query" name:"ReceiverId"`
	AppId       string `position:"Query" name:"AppId"`
	DeleterId   string `position:"Query" name:"DeleterId"`
	DeleterInfo string `position:"Query" name:"DeleterInfo"`
}

// DeleteLiveMessageUserMessageResponse is the response struct for api DeleteLiveMessageUserMessage
type DeleteLiveMessageUserMessageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveMessageUserMessageRequest creates a request to invoke DeleteLiveMessageUserMessage API
func CreateDeleteLiveMessageUserMessageRequest() (request *DeleteLiveMessageUserMessageRequest) {
	request = &DeleteLiveMessageUserMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveMessageUserMessage", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveMessageUserMessageResponse creates a response to parse from DeleteLiveMessageUserMessage response
func CreateDeleteLiveMessageUserMessageResponse() (response *DeleteLiveMessageUserMessageResponse) {
	response = &DeleteLiveMessageUserMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
