package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveAIStudio invokes the live.DeleteLiveAIStudio API synchronously
func (client *Client) DeleteLiveAIStudio(request *DeleteLiveAIStudioRequest) (response *DeleteLiveAIStudioResponse, err error) {
	response = CreateDeleteLiveAIStudioResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveAIStudioWithChan invokes the live.DeleteLiveAIStudio API asynchronously
func (client *Client) DeleteLiveAIStudioWithChan(request *DeleteLiveAIStudioRequest) (<-chan *DeleteLiveAIStudioResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveAIStudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveAIStudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveAIStudioWithCallback invokes the live.DeleteLiveAIStudio API asynchronously
func (client *Client) DeleteLiveAIStudioWithCallback(request *DeleteLiveAIStudioRequest, callback func(response *DeleteLiveAIStudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveAIStudioResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveAIStudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveAIStudioRequest is the request struct for api DeleteLiveAIStudio
type DeleteLiveAIStudioRequest struct {
	*requests.RpcRequest
	StudioId string           `position:"Query" name:"StudioId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveAIStudioResponse is the response struct for api DeleteLiveAIStudio
type DeleteLiveAIStudioResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveAIStudioRequest creates a request to invoke DeleteLiveAIStudio API
func CreateDeleteLiveAIStudioRequest() (request *DeleteLiveAIStudioRequest) {
	request = &DeleteLiveAIStudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveAIStudio", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveAIStudioResponse creates a response to parse from DeleteLiveAIStudio response
func CreateDeleteLiveAIStudioResponse() (response *DeleteLiveAIStudioResponse) {
	response = &DeleteLiveAIStudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
