package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRtcMPUEventSub invokes the live.CreateRtcMPUEventSub API synchronously
func (client *Client) CreateRtcMPUEventSub(request *CreateRtcMPUEventSubRequest) (response *CreateRtcMPUEventSubResponse, err error) {
	response = CreateCreateRtcMPUEventSubResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRtcMPUEventSubWithChan invokes the live.CreateRtcMPUEventSub API asynchronously
func (client *Client) CreateRtcMPUEventSubWithChan(request *CreateRtcMPUEventSubRequest) (<-chan *CreateRtcMPUEventSubResponse, <-chan error) {
	responseChan := make(chan *CreateRtcMPUEventSubResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRtcMPUEventSub(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRtcMPUEventSubWithCallback invokes the live.CreateRtcMPUEventSub API asynchronously
func (client *Client) CreateRtcMPUEventSubWithCallback(request *CreateRtcMPUEventSubRequest, callback func(response *CreateRtcMPUEventSubResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRtcMPUEventSubResponse
		var err error
		defer close(result)
		response, err = client.CreateRtcMPUEventSub(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRtcMPUEventSubRequest is the request struct for api CreateRtcMPUEventSub
type CreateRtcMPUEventSubRequest struct {
	*requests.RpcRequest
	AppId       string `position:"Query" name:"AppId"`
	CallbackUrl string `position:"Query" name:"CallbackUrl"`
	ChannelIds  string `position:"Query" name:"ChannelIds"`
}

// CreateRtcMPUEventSubResponse is the response struct for api CreateRtcMPUEventSub
type CreateRtcMPUEventSubResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SubId     string `json:"SubId" xml:"SubId"`
}

// CreateCreateRtcMPUEventSubRequest creates a request to invoke CreateRtcMPUEventSub API
func CreateCreateRtcMPUEventSubRequest() (request *CreateRtcMPUEventSubRequest) {
	request = &CreateRtcMPUEventSubRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateRtcMPUEventSub", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateRtcMPUEventSubResponse creates a response to parse from CreateRtcMPUEventSub response
func CreateCreateRtcMPUEventSubResponse() (response *CreateRtcMPUEventSubResponse) {
	response = &CreateRtcMPUEventSubResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
