package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRentedJoinPermissions invokes the linkwan.ListRentedJoinPermissions API synchronously
func (client *Client) ListRentedJoinPermissions(request *ListRentedJoinPermissionsRequest) (response *ListRentedJoinPermissionsResponse, err error) {
	response = CreateListRentedJoinPermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRentedJoinPermissionsWithChan invokes the linkwan.ListRentedJoinPermissions API asynchronously
func (client *Client) ListRentedJoinPermissionsWithChan(request *ListRentedJoinPermissionsRequest) (<-chan *ListRentedJoinPermissionsResponse, <-chan error) {
	responseChan := make(chan *ListRentedJoinPermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRentedJoinPermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRentedJoinPermissionsWithCallback invokes the linkwan.ListRentedJoinPermissions API asynchronously
func (client *Client) ListRentedJoinPermissionsWithCallback(request *ListRentedJoinPermissionsRequest, callback func(response *ListRentedJoinPermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRentedJoinPermissionsResponse
		var err error
		defer close(result)
		response, err = client.ListRentedJoinPermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRentedJoinPermissionsRequest is the request struct for api ListRentedJoinPermissions
type ListRentedJoinPermissionsRequest struct {
	*requests.RpcRequest
	Type                    string           `position:"Query" name:"Type"`
	Enabled                 requests.Boolean `position:"Query" name:"Enabled"`
	IotInstanceId           string           `position:"Query" name:"IotInstanceId"`
	FuzzyJoinEui            string           `position:"Query" name:"FuzzyJoinEui"`
	Limit                   requests.Integer `position:"Query" name:"Limit"`
	FuzzyJoinPermissionName string           `position:"Query" name:"FuzzyJoinPermissionName"`
	Offset                  requests.Integer `position:"Query" name:"Offset"`
	Ascending               requests.Boolean `position:"Query" name:"Ascending"`
	BoundNodeGroup          requests.Boolean `position:"Query" name:"BoundNodeGroup"`
	ApiProduct              string           `position:"Body" name:"ApiProduct"`
	ApiRevision             string           `position:"Body" name:"ApiRevision"`
	FuzzyOwnerAliyunId      string           `position:"Query" name:"FuzzyOwnerAliyunId"`
	SortingField            string           `position:"Query" name:"SortingField"`
}

// ListRentedJoinPermissionsResponse is the response struct for api ListRentedJoinPermissions
type ListRentedJoinPermissionsResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   bool                            `json:"Success" xml:"Success"`
	Data      DataInListRentedJoinPermissions `json:"Data" xml:"Data"`
}

// CreateListRentedJoinPermissionsRequest creates a request to invoke ListRentedJoinPermissions API
func CreateListRentedJoinPermissionsRequest() (request *ListRentedJoinPermissionsRequest) {
	request = &ListRentedJoinPermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListRentedJoinPermissions", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRentedJoinPermissionsResponse creates a response to parse from ListRentedJoinPermissions response
func CreateListRentedJoinPermissionsResponse() (response *ListRentedJoinPermissionsResponse) {
	response = &ListRentedJoinPermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
