package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecord invokes the linkvisual.QueryRecord API synchronously
func (client *Client) QueryRecord(request *QueryRecordRequest) (response *QueryRecordResponse, err error) {
	response = CreateQueryRecordResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecordWithChan invokes the linkvisual.QueryRecord API asynchronously
func (client *Client) QueryRecordWithChan(request *QueryRecordRequest) (<-chan *QueryRecordResponse, <-chan error) {
	responseChan := make(chan *QueryRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecordWithCallback invokes the linkvisual.QueryRecord API asynchronously
func (client *Client) QueryRecordWithCallback(request *QueryRecordRequest, callback func(response *QueryRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecordResponse
		var err error
		defer close(result)
		response, err = client.QueryRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecordRequest is the request struct for api QueryRecord
type QueryRecordRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	RecordType    requests.Integer `position:"Query" name:"RecordType"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	StreamType    requests.Integer `position:"Query" name:"StreamType"`
	NeedSnapshot  requests.Boolean `position:"Query" name:"NeedSnapshot"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	BeginTime     requests.Integer `position:"Query" name:"BeginTime"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryRecordResponse is the response struct for api QueryRecord
type QueryRecordResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryRecordRequest creates a request to invoke QueryRecord API
func CreateQueryRecordRequest() (request *QueryRecordRequest) {
	request = &QueryRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryRecord", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRecordResponse creates a response to parse from QueryRecord response
func CreateQueryRecordResponse() (response *QueryRecordResponse) {
	response = &QueryRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
