package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLocalFileUploadJob invokes the linkvisual.QueryLocalFileUploadJob API synchronously
func (client *Client) QueryLocalFileUploadJob(request *QueryLocalFileUploadJobRequest) (response *QueryLocalFileUploadJobResponse, err error) {
	response = CreateQueryLocalFileUploadJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLocalFileUploadJobWithChan invokes the linkvisual.QueryLocalFileUploadJob API asynchronously
func (client *Client) QueryLocalFileUploadJobWithChan(request *QueryLocalFileUploadJobRequest) (<-chan *QueryLocalFileUploadJobResponse, <-chan error) {
	responseChan := make(chan *QueryLocalFileUploadJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLocalFileUploadJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLocalFileUploadJobWithCallback invokes the linkvisual.QueryLocalFileUploadJob API asynchronously
func (client *Client) QueryLocalFileUploadJobWithCallback(request *QueryLocalFileUploadJobRequest, callback func(response *QueryLocalFileUploadJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLocalFileUploadJobResponse
		var err error
		defer close(result)
		response, err = client.QueryLocalFileUploadJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLocalFileUploadJobRequest is the request struct for api QueryLocalFileUploadJob
type QueryLocalFileUploadJobRequest struct {
	*requests.RpcRequest
	JobId         string `position:"Query" name:"JobId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QueryLocalFileUploadJobResponse is the response struct for api QueryLocalFileUploadJob
type QueryLocalFileUploadJobResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryLocalFileUploadJobRequest creates a request to invoke QueryLocalFileUploadJob API
func CreateQueryLocalFileUploadJobRequest() (request *QueryLocalFileUploadJobRequest) {
	request = &QueryLocalFileUploadJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryLocalFileUploadJob", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryLocalFileUploadJobResponse creates a response to parse from QueryLocalFileUploadJob response
func CreateQueryLocalFileUploadJobResponse() (response *QueryLocalFileUploadJobResponse) {
	response = &QueryLocalFileUploadJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
