package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceAllUserGroup invokes the linkvisual.QueryFaceAllUserGroup API synchronously
func (client *Client) QueryFaceAllUserGroup(request *QueryFaceAllUserGroupRequest) (response *QueryFaceAllUserGroupResponse, err error) {
	response = CreateQueryFaceAllUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceAllUserGroupWithChan invokes the linkvisual.QueryFaceAllUserGroup API asynchronously
func (client *Client) QueryFaceAllUserGroupWithChan(request *QueryFaceAllUserGroupRequest) (<-chan *QueryFaceAllUserGroupResponse, <-chan error) {
	responseChan := make(chan *QueryFaceAllUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceAllUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceAllUserGroupWithCallback invokes the linkvisual.QueryFaceAllUserGroup API asynchronously
func (client *Client) QueryFaceAllUserGroupWithCallback(request *QueryFaceAllUserGroupRequest, callback func(response *QueryFaceAllUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceAllUserGroupResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceAllUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceAllUserGroupRequest is the request struct for api QueryFaceAllUserGroup
type QueryFaceAllUserGroupRequest struct {
	*requests.RpcRequest
	IsolationId string           `position:"Query" name:"IsolationId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// QueryFaceAllUserGroupResponse is the response struct for api QueryFaceAllUserGroup
type QueryFaceAllUserGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceAllUserGroupRequest creates a request to invoke QueryFaceAllUserGroup API
func CreateQueryFaceAllUserGroupRequest() (request *QueryFaceAllUserGroupRequest) {
	request = &QueryFaceAllUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceAllUserGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceAllUserGroupResponse creates a response to parse from QueryFaceAllUserGroup response
func CreateQueryFaceAllUserGroupResponse() (response *QueryFaceAllUserGroupResponse) {
	response = &QueryFaceAllUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
