package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetThingModelTslPublished invokes the iot.GetThingModelTslPublished API synchronously
func (client *Client) GetThingModelTslPublished(request *GetThingModelTslPublishedRequest) (response *GetThingModelTslPublishedResponse, err error) {
	response = CreateGetThingModelTslPublishedResponse()
	err = client.DoAction(request, response)
	return
}

// GetThingModelTslPublishedWithChan invokes the iot.GetThingModelTslPublished API asynchronously
func (client *Client) GetThingModelTslPublishedWithChan(request *GetThingModelTslPublishedRequest) (<-chan *GetThingModelTslPublishedResponse, <-chan error) {
	responseChan := make(chan *GetThingModelTslPublishedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetThingModelTslPublished(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetThingModelTslPublishedWithCallback invokes the iot.GetThingModelTslPublished API asynchronously
func (client *Client) GetThingModelTslPublishedWithCallback(request *GetThingModelTslPublishedRequest, callback func(response *GetThingModelTslPublishedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetThingModelTslPublishedResponse
		var err error
		defer close(result)
		response, err = client.GetThingModelTslPublished(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetThingModelTslPublishedRequest is the request struct for api GetThingModelTslPublished
type GetThingModelTslPublishedRequest struct {
	*requests.RpcRequest
	RealTenantId      string           `position:"Query" name:"RealTenantId"`
	Simple            requests.Boolean `position:"Query" name:"Simple"`
	RealTripartiteKey string           `position:"Query" name:"RealTripartiteKey"`
	ResourceGroupId   string           `position:"Query" name:"ResourceGroupId"`
	IotInstanceId     string           `position:"Query" name:"IotInstanceId"`
	ProductKey        string           `position:"Query" name:"ProductKey"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
	ModelVersion      string           `position:"Query" name:"ModelVersion"`
	FunctionBlockId   string           `position:"Query" name:"FunctionBlockId"`
}

// GetThingModelTslPublishedResponse is the response struct for api GetThingModelTslPublished
type GetThingModelTslPublishedResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetThingModelTslPublishedRequest creates a request to invoke GetThingModelTslPublished API
func CreateGetThingModelTslPublishedRequest() (request *GetThingModelTslPublishedRequest) {
	request = &GetThingModelTslPublishedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetThingModelTslPublished", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetThingModelTslPublishedResponse creates a response to parse from GetThingModelTslPublished response
func CreateGetThingModelTslPublishedResponse() (response *GetThingModelTslPublishedResponse) {
	response = &GetThingModelTslPublishedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
