package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserDefineTableDataByPrimaryKey invokes the iot.DeleteUserDefineTableDataByPrimaryKey API synchronously
func (client *Client) DeleteUserDefineTableDataByPrimaryKey(request *DeleteUserDefineTableDataByPrimaryKeyRequest) (response *DeleteUserDefineTableDataByPrimaryKeyResponse, err error) {
	response = CreateDeleteUserDefineTableDataByPrimaryKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserDefineTableDataByPrimaryKeyWithChan invokes the iot.DeleteUserDefineTableDataByPrimaryKey API asynchronously
func (client *Client) DeleteUserDefineTableDataByPrimaryKeyWithChan(request *DeleteUserDefineTableDataByPrimaryKeyRequest) (<-chan *DeleteUserDefineTableDataByPrimaryKeyResponse, <-chan error) {
	responseChan := make(chan *DeleteUserDefineTableDataByPrimaryKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserDefineTableDataByPrimaryKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserDefineTableDataByPrimaryKeyWithCallback invokes the iot.DeleteUserDefineTableDataByPrimaryKey API asynchronously
func (client *Client) DeleteUserDefineTableDataByPrimaryKeyWithCallback(request *DeleteUserDefineTableDataByPrimaryKeyRequest, callback func(response *DeleteUserDefineTableDataByPrimaryKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserDefineTableDataByPrimaryKeyResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserDefineTableDataByPrimaryKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserDefineTableDataByPrimaryKeyRequest is the request struct for api DeleteUserDefineTableDataByPrimaryKey
type DeleteUserDefineTableDataByPrimaryKeyRequest struct {
	*requests.RpcRequest
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	TableIdentifier string `position:"Query" name:"TableIdentifier"`
	ApiProduct      string `position:"Body" name:"ApiProduct"`
	ApiRevision     string `position:"Body" name:"ApiRevision"`
	Conditions      string `position:"Query" name:"Conditions"`
}

// DeleteUserDefineTableDataByPrimaryKeyResponse is the response struct for api DeleteUserDefineTableDataByPrimaryKey
type DeleteUserDefineTableDataByPrimaryKeyResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteUserDefineTableDataByPrimaryKeyRequest creates a request to invoke DeleteUserDefineTableDataByPrimaryKey API
func CreateDeleteUserDefineTableDataByPrimaryKeyRequest() (request *DeleteUserDefineTableDataByPrimaryKeyRequest) {
	request = &DeleteUserDefineTableDataByPrimaryKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteUserDefineTableDataByPrimaryKey", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteUserDefineTableDataByPrimaryKeyResponse creates a response to parse from DeleteUserDefineTableDataByPrimaryKey response
func CreateDeleteUserDefineTableDataByPrimaryKeyResponse() (response *DeleteUserDefineTableDataByPrimaryKeyResponse) {
	response = &DeleteUserDefineTableDataByPrimaryKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
