package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindProjectProducts invokes the iot.BatchUnbindProjectProducts API synchronously
func (client *Client) BatchUnbindProjectProducts(request *BatchUnbindProjectProductsRequest) (response *BatchUnbindProjectProductsResponse, err error) {
	response = CreateBatchUnbindProjectProductsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindProjectProductsWithChan invokes the iot.BatchUnbindProjectProducts API asynchronously
func (client *Client) BatchUnbindProjectProductsWithChan(request *BatchUnbindProjectProductsRequest) (<-chan *BatchUnbindProjectProductsResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindProjectProductsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindProjectProducts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindProjectProductsWithCallback invokes the iot.BatchUnbindProjectProducts API asynchronously
func (client *Client) BatchUnbindProjectProductsWithCallback(request *BatchUnbindProjectProductsRequest, callback func(response *BatchUnbindProjectProductsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindProjectProductsResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindProjectProducts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindProjectProductsRequest is the request struct for api BatchUnbindProjectProducts
type BatchUnbindProjectProductsRequest struct {
	*requests.RpcRequest
	ProductKeys   *[]string `position:"Body" name:"ProductKeys"  type:"Repeated"`
	IotInstanceId string    `position:"Body" name:"IotInstanceId"`
	ProjectId     string    `position:"Body" name:"ProjectId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// BatchUnbindProjectProductsResponse is the response struct for api BatchUnbindProjectProducts
type BatchUnbindProjectProductsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateBatchUnbindProjectProductsRequest creates a request to invoke BatchUnbindProjectProducts API
func CreateBatchUnbindProjectProductsRequest() (request *BatchUnbindProjectProductsRequest) {
	request = &BatchUnbindProjectProductsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchUnbindProjectProducts", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindProjectProductsResponse creates a response to parse from BatchUnbindProjectProducts response
func CreateBatchUnbindProjectProductsResponse() (response *BatchUnbindProjectProductsResponse) {
	response = &BatchUnbindProjectProductsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
