package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScreenCRC invokes the imageprocess.ScreenCRC API synchronously
func (client *Client) ScreenCRC(request *ScreenCRCRequest) (response *ScreenCRCResponse, err error) {
	response = CreateScreenCRCResponse()
	err = client.DoAction(request, response)
	return
}

// ScreenCRCWithChan invokes the imageprocess.ScreenCRC API asynchronously
func (client *Client) ScreenCRCWithChan(request *ScreenCRCRequest) (<-chan *ScreenCRCResponse, <-chan error) {
	responseChan := make(chan *ScreenCRCResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScreenCRC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScreenCRCWithCallback invokes the imageprocess.ScreenCRC API asynchronously
func (client *Client) ScreenCRCWithCallback(request *ScreenCRCRequest, callback func(response *ScreenCRCResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScreenCRCResponse
		var err error
		defer close(result)
		response, err = client.ScreenCRC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScreenCRCRequest is the request struct for api ScreenCRC
type ScreenCRCRequest struct {
	*requests.RpcRequest
	DataSourceType string              `position:"Body" name:"DataSourceType"`
	OrgName        string              `position:"Body" name:"OrgName"`
	DataFormat     string              `position:"Body" name:"DataFormat"`
	URLList        *[]ScreenCRCURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId          string              `position:"Body" name:"OrgId"`
	Async          requests.Boolean    `position:"Body" name:"Async"`
}

// ScreenCRCURLList is a repeated param struct in ScreenCRCRequest
type ScreenCRCURLList struct {
	URL string `name:"URL"`
}

// ScreenCRCResponse is the response struct for api ScreenCRC
type ScreenCRCResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScreenCRCRequest creates a request to invoke ScreenCRC API
func CreateScreenCRCRequest() (request *ScreenCRCRequest) {
	request = &ScreenCRCRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "ScreenCRC", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScreenCRCResponse creates a response to parse from ScreenCRC response
func CreateScreenCRCResponse() (response *ScreenCRCResponse) {
	response = &ScreenCRCResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
