package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLdpsComputeGroup invokes the hitsdb.GetLdpsComputeGroup API synchronously
func (client *Client) GetLdpsComputeGroup(request *GetLdpsComputeGroupRequest) (response *GetLdpsComputeGroupResponse, err error) {
	response = CreateGetLdpsComputeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetLdpsComputeGroupWithChan invokes the hitsdb.GetLdpsComputeGroup API asynchronously
func (client *Client) GetLdpsComputeGroupWithChan(request *GetLdpsComputeGroupRequest) (<-chan *GetLdpsComputeGroupResponse, <-chan error) {
	responseChan := make(chan *GetLdpsComputeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLdpsComputeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLdpsComputeGroupWithCallback invokes the hitsdb.GetLdpsComputeGroup API asynchronously
func (client *Client) GetLdpsComputeGroupWithCallback(request *GetLdpsComputeGroupRequest, callback func(response *GetLdpsComputeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLdpsComputeGroupResponse
		var err error
		defer close(result)
		response, err = client.GetLdpsComputeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLdpsComputeGroupRequest is the request struct for api GetLdpsComputeGroup
type GetLdpsComputeGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GroupName            string           `position:"Query" name:"GroupName"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetLdpsComputeGroupResponse is the response struct for api GetLdpsComputeGroup
type GetLdpsComputeGroupResponse struct {
	*responses.BaseResponse
	RequestId  string                 `json:"RequestId" xml:"RequestId"`
	GroupName  string                 `json:"GroupName" xml:"GroupName"`
	Properties map[string]interface{} `json:"Properties" xml:"Properties"`
}

// CreateGetLdpsComputeGroupRequest creates a request to invoke GetLdpsComputeGroup API
func CreateGetLdpsComputeGroupRequest() (request *GetLdpsComputeGroupRequest) {
	request = &GetLdpsComputeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetLdpsComputeGroup", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLdpsComputeGroupResponse creates a response to parse from GetLdpsComputeGroup response
func CreateGetLdpsComputeGroupResponse() (response *GetLdpsComputeGroupResponse) {
	response = &GetLdpsComputeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
