package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBackupPlanConfig invokes the hbase.ModifyBackupPlanConfig API synchronously
func (client *Client) ModifyBackupPlanConfig(request *ModifyBackupPlanConfigRequest) (response *ModifyBackupPlanConfigResponse, err error) {
	response = CreateModifyBackupPlanConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBackupPlanConfigWithChan invokes the hbase.ModifyBackupPlanConfig API asynchronously
func (client *Client) ModifyBackupPlanConfigWithChan(request *ModifyBackupPlanConfigRequest) (<-chan *ModifyBackupPlanConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyBackupPlanConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBackupPlanConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBackupPlanConfigWithCallback invokes the hbase.ModifyBackupPlanConfig API asynchronously
func (client *Client) ModifyBackupPlanConfigWithCallback(request *ModifyBackupPlanConfigRequest, callback func(response *ModifyBackupPlanConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBackupPlanConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyBackupPlanConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBackupPlanConfigRequest is the request struct for api ModifyBackupPlanConfig
type ModifyBackupPlanConfigRequest struct {
	*requests.RpcRequest
	FullBackupCycle     string `position:"Query" name:"FullBackupCycle"`
	Tables              string `position:"Query" name:"Tables"`
	ClusterId           string `position:"Query" name:"ClusterId"`
	MinHFileBackupCount string `position:"Query" name:"MinHFileBackupCount"`
	NextFullBackupDate  string `position:"Query" name:"NextFullBackupDate"`
}

// ModifyBackupPlanConfigResponse is the response struct for api ModifyBackupPlanConfig
type ModifyBackupPlanConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBackupPlanConfigRequest creates a request to invoke ModifyBackupPlanConfig API
func CreateModifyBackupPlanConfigRequest() (request *ModifyBackupPlanConfigRequest) {
	request = &ModifyBackupPlanConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyBackupPlanConfig", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyBackupPlanConfigResponse creates a response to parse from ModifyBackupPlanConfig response
func CreateModifyBackupPlanConfigResponse() (response *ModifyBackupPlanConfigResponse) {
	response = &ModifyBackupPlanConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
