package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServerGroupServers invokes the gwlb.ListServerGroupServers API synchronously
func (client *Client) ListServerGroupServers(request *ListServerGroupServersRequest) (response *ListServerGroupServersResponse, err error) {
	response = CreateListServerGroupServersResponse()
	err = client.DoAction(request, response)
	return
}

// ListServerGroupServersWithChan invokes the gwlb.ListServerGroupServers API asynchronously
func (client *Client) ListServerGroupServersWithChan(request *ListServerGroupServersRequest) (<-chan *ListServerGroupServersResponse, <-chan error) {
	responseChan := make(chan *ListServerGroupServersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServerGroupServers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServerGroupServersWithCallback invokes the gwlb.ListServerGroupServers API asynchronously
func (client *Client) ListServerGroupServersWithCallback(request *ListServerGroupServersRequest, callback func(response *ListServerGroupServersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServerGroupServersResponse
		var err error
		defer close(result)
		response, err = client.ListServerGroupServers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServerGroupServersRequest is the request struct for api ListServerGroupServers
type ListServerGroupServersRequest struct {
	*requests.RpcRequest
	Skip          requests.Integer `position:"Body" name:"Skip"`
	ServerGroupId string           `position:"Body" name:"ServerGroupId"`
	NextToken     string           `position:"Body" name:"NextToken"`
	ServerIds     *[]string        `position:"Body" name:"ServerIds"  type:"Repeated"`
	ServerIps     *[]string        `position:"Body" name:"ServerIps"  type:"Repeated"`
	MaxResults    requests.Integer `position:"Body" name:"MaxResults"`
}

// ListServerGroupServersResponse is the response struct for api ListServerGroupServers
type ListServerGroupServersResponse struct {
	*responses.BaseResponse
	MaxResults int      `json:"MaxResults" xml:"MaxResults"`
	NextToken  string   `json:"NextToken" xml:"NextToken"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	Servers    []Server `json:"Servers" xml:"Servers"`
}

// CreateListServerGroupServersRequest creates a request to invoke ListServerGroupServers API
func CreateListServerGroupServersRequest() (request *ListServerGroupServersRequest) {
	request = &ListServerGroupServersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "ListServerGroupServers", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListServerGroupServersResponse creates a response to parse from ListServerGroupServers response
func CreateListServerGroupServersResponse() (response *ListServerGroupServersResponse) {
	response = &ListServerGroupServersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
