package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLoadBalancerAttribute invokes the gwlb.GetLoadBalancerAttribute API synchronously
func (client *Client) GetLoadBalancerAttribute(request *GetLoadBalancerAttributeRequest) (response *GetLoadBalancerAttributeResponse, err error) {
	response = CreateGetLoadBalancerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetLoadBalancerAttributeWithChan invokes the gwlb.GetLoadBalancerAttribute API asynchronously
func (client *Client) GetLoadBalancerAttributeWithChan(request *GetLoadBalancerAttributeRequest) (<-chan *GetLoadBalancerAttributeResponse, <-chan error) {
	responseChan := make(chan *GetLoadBalancerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLoadBalancerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLoadBalancerAttributeWithCallback invokes the gwlb.GetLoadBalancerAttribute API asynchronously
func (client *Client) GetLoadBalancerAttributeWithCallback(request *GetLoadBalancerAttributeRequest, callback func(response *GetLoadBalancerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLoadBalancerAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetLoadBalancerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLoadBalancerAttributeRequest is the request struct for api GetLoadBalancerAttribute
type GetLoadBalancerAttributeRequest struct {
	*requests.RpcRequest
	LoadBalancerId string `position:"Body" name:"LoadBalancerId"`
}

// GetLoadBalancerAttributeResponse is the response struct for api GetLoadBalancerAttribute
type GetLoadBalancerAttributeResponse struct {
	*responses.BaseResponse
	AddressIpVersion           string         `json:"AddressIpVersion" xml:"AddressIpVersion"`
	CreateTime                 string         `json:"CreateTime" xml:"CreateTime"`
	CrossZoneEnabled           bool           `json:"CrossZoneEnabled" xml:"CrossZoneEnabled"`
	LoadBalancerBusinessStatus string         `json:"LoadBalancerBusinessStatus" xml:"LoadBalancerBusinessStatus"`
	LoadBalancerId             string         `json:"LoadBalancerId" xml:"LoadBalancerId"`
	LoadBalancerName           string         `json:"LoadBalancerName" xml:"LoadBalancerName"`
	LoadBalancerStatus         string         `json:"LoadBalancerStatus" xml:"LoadBalancerStatus"`
	RequestId                  string         `json:"RequestId" xml:"RequestId"`
	ResourceGroupId            string         `json:"ResourceGroupId" xml:"ResourceGroupId"`
	VpcId                      string         `json:"VpcId" xml:"VpcId"`
	Tags                       []TagModel     `json:"Tags" xml:"Tags"`
	ZoneMappings               []ZoneEniModel `json:"ZoneMappings" xml:"ZoneMappings"`
}

// CreateGetLoadBalancerAttributeRequest creates a request to invoke GetLoadBalancerAttribute API
func CreateGetLoadBalancerAttributeRequest() (request *GetLoadBalancerAttributeRequest) {
	request = &GetLoadBalancerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "GetLoadBalancerAttribute", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLoadBalancerAttributeResponse creates a response to parse from GetLoadBalancerAttribute response
func CreateGetLoadBalancerAttributeResponse() (response *GetLoadBalancerAttributeResponse) {
	response = &GetLoadBalancerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
