package gwlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateListener invokes the gwlb.CreateListener API synchronously
func (client *Client) CreateListener(request *CreateListenerRequest) (response *CreateListenerResponse, err error) {
	response = CreateCreateListenerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateListenerWithChan invokes the gwlb.CreateListener API asynchronously
func (client *Client) CreateListenerWithChan(request *CreateListenerRequest) (<-chan *CreateListenerResponse, <-chan error) {
	responseChan := make(chan *CreateListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateListenerWithCallback invokes the gwlb.CreateListener API asynchronously
func (client *Client) CreateListenerWithCallback(request *CreateListenerRequest, callback func(response *CreateListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateListenerResponse
		var err error
		defer close(result)
		response, err = client.CreateListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateListenerRequest is the request struct for api CreateListener
type CreateListenerRequest struct {
	*requests.RpcRequest
	ClientToken         string               `position:"Body" name:"ClientToken"`
	ServerGroupId       string               `position:"Body" name:"ServerGroupId"`
	Tag                 *[]CreateListenerTag `position:"Body" name:"Tag"  type:"Repeated"`
	DryRun              requests.Boolean     `position:"Body" name:"DryRun"`
	LoadBalancerId      string               `position:"Body" name:"LoadBalancerId"`
	ListenerDescription string               `position:"Body" name:"ListenerDescription"`
}

// CreateListenerTag is a repeated param struct in CreateListenerRequest
type CreateListenerTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateListenerResponse is the response struct for api CreateListener
type CreateListenerResponse struct {
	*responses.BaseResponse
	ListenerId string `json:"ListenerId" xml:"ListenerId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateListenerRequest creates a request to invoke CreateListener API
func CreateCreateListenerRequest() (request *CreateListenerRequest) {
	request = &CreateListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Gwlb", "2024-04-15", "CreateListener", "gwlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateListenerResponse creates a response to parse from CreateListener response
func CreateCreateListenerResponse() (response *CreateListenerResponse) {
	response = &CreateListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
