package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataSharePerformance invokes the gpdb.DescribeDataSharePerformance API synchronously
func (client *Client) DescribeDataSharePerformance(request *DescribeDataSharePerformanceRequest) (response *DescribeDataSharePerformanceResponse, err error) {
	response = CreateDescribeDataSharePerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataSharePerformanceWithChan invokes the gpdb.DescribeDataSharePerformance API asynchronously
func (client *Client) DescribeDataSharePerformanceWithChan(request *DescribeDataSharePerformanceRequest) (<-chan *DescribeDataSharePerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeDataSharePerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataSharePerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataSharePerformanceWithCallback invokes the gpdb.DescribeDataSharePerformance API asynchronously
func (client *Client) DescribeDataSharePerformanceWithCallback(request *DescribeDataSharePerformanceRequest, callback func(response *DescribeDataSharePerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataSharePerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataSharePerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataSharePerformanceRequest is the request struct for api DescribeDataSharePerformance
type DescribeDataSharePerformanceRequest struct {
	*requests.RpcRequest
	EndTime         string `position:"Query" name:"EndTime"`
	StartTime       string `position:"Query" name:"StartTime"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	Key             string `position:"Query" name:"Key"`
}

// DescribeDataSharePerformanceResponse is the response struct for api DescribeDataSharePerformance
type DescribeDataSharePerformanceResponse struct {
	*responses.BaseResponse
	EndTime         string            `json:"EndTime" xml:"EndTime"`
	RequestId       string            `json:"RequestId" xml:"RequestId"`
	StartTime       string            `json:"StartTime" xml:"StartTime"`
	DBClusterId     string            `json:"DBClusterId" xml:"DBClusterId"`
	PerformanceKeys []PerformanceItem `json:"PerformanceKeys" xml:"PerformanceKeys"`
}

// CreateDescribeDataSharePerformanceRequest creates a request to invoke DescribeDataSharePerformance API
func CreateDescribeDataSharePerformanceRequest() (request *DescribeDataSharePerformanceRequest) {
	request = &DescribeDataSharePerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDataSharePerformance", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDataSharePerformanceResponse creates a response to parse from DescribeDataSharePerformance response
func CreateDescribeDataSharePerformanceResponse() (response *DescribeDataSharePerformanceResponse) {
	response = &DescribeDataSharePerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
